/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.jetbrains.annotations.NotNull;

public class ProgressBarLoadingDecorator
extends LoadingDecorator {
    private final AtomicBoolean loadingStarted = new AtomicBoolean(false);
    private JProgressBar myProgressBar;

    public ProgressBarLoadingDecorator(@NotNull JPanel contentPanel, @NotNull Disposable disposable, int startDelayMs) {
        super(contentPanel, disposable, startDelayMs, true);
    }

    @Override
    protected NonOpaquePanel customizeLoadingLayer(JPanel parent, JLabel text, AsyncProcessIcon icon) {
        parent.setLayout(new BorderLayout());
        NonOpaquePanel result = new NonOpaquePanel();
        result.setLayout(new BoxLayout(result, 1));
        this.myProgressBar = new JProgressBar();
        this.myProgressBar.setIndeterminate(true);
        this.myProgressBar.putClientProperty("ProgressBar.stripeWidth", 2);
        this.myProgressBar.putClientProperty("ProgressBar.flatEnds", Boolean.TRUE);
        result.add(this.myProgressBar);
        parent.add((Component)result, "North");
        return result;
    }

    @NotNull
    public JProgressBar getProgressBar() {
        return this.myProgressBar;
    }

    public void startLoading() {
        if (this.loadingStarted.compareAndSet(false, true)) {
            super.startLoading(false);
        }
    }

    @Override
    public void stopLoading() {
        if (this.loadingStarted.compareAndSet(true, false)) {
            super.stopLoading();
        }
    }
}

