/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.LinkCellRenderer;
import com.intellij.ui.popup.util.PopupState;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B-\b\u0017\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bB3\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB'\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0000\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a2\u0006\u0002\u0010 J\u0013\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0002\u0010$R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0016\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00028\u0000@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lcom/intellij/ui/components/DropDownLink;", "T", "Lcom/intellij/ui/components/ActionLink;", "item", "items", "", "onChoose", "Ljava/util/function/Consumer;", "(Ljava/lang/Object;Ljava/util/List;Ljava/util/function/Consumer;)V", "onSelect", "updateText", "", "(Ljava/lang/Object;Ljava/util/List;Ljava/util/function/Consumer;Z)V", "popupBuilder", "Lkotlin/Function1;", "Lcom/intellij/openapi/ui/popup/JBPopup;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "popupState", "Lcom/intellij/ui/popup/util/PopupState;", "getPopupState", "()Lcom/intellij/ui/popup/util/PopupState;", "newItem", "selectedItem", "getSelectedItem", "()Ljava/lang/Object;", "setSelectedItem", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "fireItemStateChanged", "", "state", "", "(Ljava/lang/Object;I)V", "getSelectedObjects", "", "", "()[Ljava/lang/Object;", "intellij.platform.ide"})
public class DropDownLink<T>
extends ActionLink {
    @NotNull
    private final PopupState popupState;
    private T selectedItem;

    @NotNull
    public final PopupState getPopupState() {
        return this.popupState;
    }

    public final T getSelectedItem() {
        return this.selectedItem;
    }

    public final void setSelectedItem(T newItem) {
        T oldItem = this.selectedItem;
        if (Intrinsics.areEqual(oldItem, newItem)) {
            return;
        }
        this.fireItemStateChanged(oldItem, 2);
        this.selectedItem = newItem;
        this.fireItemStateChanged(newItem, 1);
    }

    @Override
    @NotNull
    public Object[] getSelectedObjects() {
        Object[] objectArray;
        T t = this.selectedItem;
        if (t != null) {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            T t3 = it;
            if (t3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Any");
            }
            objectArray2[0] = t3;
        } else {
            objectArray = new Object[]{};
        }
        return objectArray;
    }

    private final void fireItemStateChanged(T item, int state) {
        ItemListener[] $this$forEach$iv = this.getItemListeners();
        boolean $i$f$forEach = false;
        ItemListener[] itemListenerArray = $this$forEach$iv;
        int n = itemListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ItemListener element$iv;
            ItemListener it = element$iv = itemListenerArray[i];
            boolean bl = false;
            it.itemStateChanged(new ItemEvent(this, 701, item, state));
        }
    }

    public DropDownLink(T item, final @NotNull Function1<? super DropDownLink<T>, ? extends JBPopup> popupBuilder) {
        this.popupState = new PopupState();
        this.selectedItem = item;
        this.setText(String.valueOf(item));
        this.setIcon(AllIcons.General.LinkDropTriangle);
        this.setIconTextGap(JBUIScale.scale((int)1));
        this.setHorizontalTextPosition(10);
        this.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                if (!this.getPopupState().isRecentlyHidden()) {
                    JBPopup popup = (JBPopup)popupBuilder.invoke((Object)this);
                    Point showPoint = new Point(0, this.getHeight() + JBUIScale.scale((int)4));
                    popup.addListener(this.getPopupState());
                    popup.show(new RelativePoint((Component)this, showPoint));
                }
            }
        });
    }

    @JvmOverloads
    public DropDownLink(T item, final @NotNull List<? extends T> items, final @NotNull java.util.function.Consumer<T> onChoose) {
        this(item, (Function1)new Function1<DropDownLink<T>, JBPopup>(){

            @NotNull
            public final JBPopup invoke(final @NotNull DropDownLink<T> link) {
                return JBPopupFactory.getInstance().createPopupChooserBuilder(items).setRenderer(new LinkCellRenderer(link)).setItemChosenCallback((Consumer)new Consumer<T>(){

                    public final void consume(T it) {
                        onChoose.accept(it);
                        link.setSelectedItem(it);
                    }
                }).createPopup();
            }
        });
    }

    public /* synthetic */ DropDownLink(Object object, List list, java.util.function.Consumer consumer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            consumer = 2.INSTANCE;
        }
        this(object, list, consumer);
    }

    @JvmOverloads
    public DropDownLink(T item, @NotNull List<? extends T> items) {
        this(item, items, null, 4, null);
    }

    public DropDownLink(T item, @NotNull List<? extends T> items, final @NotNull java.util.function.Consumer<T> onSelect, final boolean updateText) {
        this(item, items, null, 4, null);
        this.addItemListener(new ItemListener(){

            @Override
            public final void itemStateChanged(ItemEvent event) {
                block3: {
                    if (event.getStateChange() != 1) break block3;
                    Object object = event.getItem();
                    if (!(object instanceof Object)) {
                        object = null;
                    }
                    if (object != null) {
                        Object object2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        Object it = object2;
                        boolean bl3 = false;
                        onSelect.accept(it);
                        if (updateText) {
                            this.setText(it.toString());
                        }
                    }
                }
            }
        });
    }
}

