/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import sun.swing.DefaultLookup;

public abstract class SimpleListCellRenderer<T>
extends JBLabel
implements ListCellRenderer<T> {
    @NotNull
    public static <T> SimpleListCellRenderer<T> create(final @NotNull String nullValue, final @NotNull Function<? super T, String> getText) {
        return new SimpleListCellRenderer<T>(){

            @Override
            public void customize(@NotNull JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
                this.setText(value == null ? nullValue : (String)getText.fun(value));
            }
        };
    }

    @NotNull
    public static <T> SimpleListCellRenderer<T> create(final @NotNull Customizer<? super T> customizer) {
        return new SimpleListCellRenderer<T>(){

            @Override
            public void customize(@NotNull JList<? extends T> list, T value, int index, boolean selected, boolean hasFocus) {
                customizer.customize(this, value, index);
            }
        };
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        Color fg;
        Color bg;
        this.setComponentOrientation(list.getComponentOrientation());
        this.setBorder((Border)JBUI.Borders.empty((int)UIUtil.getListCellVPadding(), (int)UIUtil.getListCellHPadding()));
        JList.DropLocation dropLocation = list.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsert() && dropLocation.getIndex() == index) {
            bg = DefaultLookup.getColor(this, this.ui, "List.dropCellBackground");
            fg = DefaultLookup.getColor(this, this.ui, "List.dropCellForeground");
            isSelected = true;
        } else {
            bg = isSelected ? list.getSelectionBackground() : list.getBackground();
            fg = isSelected ? list.getSelectionForeground() : list.getForeground();
        }
        this.setBackground(bg);
        this.setForeground(fg);
        this.setFont(list.getFont());
        this.setText("");
        this.setIcon(null);
        this.customize(list, value, index, isSelected, cellHasFocus);
        this.setOpaque(isSelected);
        return this;
    }

    public abstract void customize(@NotNull JList<? extends T> var1, T var2, int var3, boolean var4, boolean var5);

    @Override
    public Dimension getPreferredSize() {
        if (StringUtil.isNotEmpty((String)this.getText())) {
            return super.getPreferredSize();
        }
        this.setText(" ");
        Dimension size = super.getPreferredSize();
        this.setText("");
        return size;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text" || (propertyName == "font" || propertyName == "foreground") && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @FunctionalInterface
    public static interface Customizer<T> {
        public void customize(@NotNull JBLabel var1, T var2, int var3);
    }
}

