/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.ListUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PopupHandler
extends MouseAdapter {
    public abstract void invokePopup(Component var1, int var2, int var3);

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.invokePopup(e.getComponent(), e.getX(), e.getY());
            e.consume();
        }
    }

    public static void installPopupHandler(JComponent component, @NonNls String groupId, @NonNls String place) {
        ActionManager actionManager = ActionManager.getInstance();
        ActionGroup group = (ActionGroup)actionManager.getAction(groupId);
        PopupHandler.installPopupHandler(component, group, place, actionManager);
    }

    @NotNull
    public static MouseListener installPopupHandler(JComponent component, @NotNull ActionGroup group, @NonNls String place) {
        return PopupHandler.installPopupHandler(component, group, place, ActionManager.getInstance());
    }

    @NotNull
    public static MouseListener installPopupHandler(JComponent component, @NotNull ActionGroup group, @NonNls String place, ActionManager actionManager) {
        return PopupHandler.installPopupHandler(component, group, place, actionManager, null);
    }

    @NotNull
    public static MouseListener installPopupHandler(final @NotNull JComponent component, final @NotNull ActionGroup group, final @NonNls String place, final @NotNull ActionManager actionManager, final @Nullable PopupMenuListener menuListener) {
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler popupHandler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                popupMenu.setTargetComponent(component);
                JPopupMenu menu = popupMenu.getComponent();
                if (menuListener != null) {
                    menu.addPopupMenuListener(menuListener);
                }
                menu.show(comp, x, y);
            }
        };
        component.addMouseListener(popupHandler);
        return popupHandler;
    }

    @NotNull
    public static MouseListener installFollowingSelectionTreePopup(@NotNull JTree tree, @NotNull ActionGroup group, @NonNls String place, @NotNull ActionManager actionManager) {
        return PopupHandler.installConditionalPopup(tree, group, place, actionManager, (comp, x, y) -> tree.getPathForLocation(x, y) != null && Arrays.binarySearch(Objects.requireNonNull(tree.getSelectionRows()), tree.getRowForLocation(x, y)) > -1);
    }

    @NotNull
    public static MouseListener installRowSelectionTablePopup(@NotNull JTable table, @NotNull ActionGroup group, @NonNls String place, @NotNull ActionManager actionManager) {
        return PopupHandler.installConditionalPopup(table, group, place, actionManager, (comp, x, y) -> Arrays.binarySearch(table.getSelectedRows(), table.rowAtPoint(new Point(x, y))) > -1);
    }

    @NotNull
    public static MouseListener installSelectionListPopup(@NotNull JList<?> list, @NotNull ActionGroup group, @NonNls String place, @NotNull ActionManager actionManager) {
        return PopupHandler.installConditionalPopup(list, group, place, actionManager, (comp, x, y) -> ListUtil.isPointOnSelection(list, x, y));
    }

    @NotNull
    private static MouseListener installConditionalPopup(@NotNull JComponent component, final @NotNull ActionGroup group, final @NonNls String place, final @NotNull ActionManager actionManager, final @NotNull ShowPopupPredicate condition) {
        if (ApplicationManager.getApplication() == null) {
            return new MouseAdapter(){};
        }
        PopupHandler handler = new PopupHandler(){

            @Override
            public void invokePopup(Component comp, int x, int y) {
                if (condition.shouldShowPopup(comp, x, y)) {
                    ActionPopupMenu popupMenu = actionManager.createActionPopupMenu(place, group);
                    popupMenu.getComponent().show(comp, x, y);
                }
            }
        };
        component.addMouseListener(handler);
        return handler;
    }

    public static MouseListener installUnknownPopupHandler(JComponent component, ActionGroup group, ActionManager actionManager) {
        return PopupHandler.installPopupHandler(component, group, "unknown", actionManager);
    }

    @FunctionalInterface
    private static interface ShowPopupPredicate {
        public boolean shouldShowPopup(Component var1, int var2, int var3);
    }
}

