/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import gnu.trove.TObjectIntHashMap;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.LayoutFocusTraversalPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListFocusTraversalPolicy
extends LayoutFocusTraversalPolicy {
    private final Component[] myComponents;
    private final TObjectIntHashMap<Component> myComponentToIndex;

    public ListFocusTraversalPolicy(@NotNull List<? extends Component> components) {
        this.myComponents = components.toArray(new Component[0]);
        this.myComponentToIndex = ListFocusTraversalPolicy.indexMap(this.myComponents);
    }

    @Override
    protected boolean accept(Component aComponent) {
        return super.accept(aComponent) && aComponent.isShowing();
    }

    @Override
    public Component getFirstComponent(Container aContainer) {
        return this.getNextComponent(0);
    }

    @Override
    public Component getLastComponent(Container aContainer) {
        return this.getPreviousComponent(this.myComponents.length - 1);
    }

    @Override
    public Component getComponentAfter(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        return this.getNextComponent(this.myComponentToIndex.get((Object)aComponent) + 1);
    }

    @Override
    public Component getComponentBefore(Container aContainer, Component aComponent) {
        if (!this.myComponentToIndex.containsKey((Object)aComponent)) {
            return null;
        }
        return this.getPreviousComponent(this.myComponentToIndex.get((Object)aComponent) - 1);
    }

    @Nullable
    private Component getNextComponent(int startIndex) {
        Component result;
        int index;
        for (index = startIndex; index < this.myComponents.length; ++index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        for (index = 0; index < startIndex; ++index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        return null;
    }

    @Nullable
    private Component getPreviousComponent(int startIndex) {
        Component result;
        int index;
        for (index = startIndex; index >= 0; --index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        for (index = this.myComponents.length - 1; index > startIndex; --index) {
            result = this.myComponents[index];
            if (!this.accept(result)) continue;
            return result;
        }
        return null;
    }

    @NotNull
    private static <X> TObjectIntHashMap<X> indexMap(X @NotNull [] array) {
        TObjectIntHashMap map = new TObjectIntHashMap(array.length);
        for (X x : array) {
            if (map.contains(x)) continue;
            map.put(x, map.size());
        }
        map.compact();
        return map;
    }
}

