/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorNotifications {
    private static final EditorNotifications NULL_IMPL = new EditorNotifications(){

        @Override
        public void updateNotifications(@NotNull VirtualFile file) {
        }

        @Override
        public void updateNotifications(@NotNull Provider<?> provider) {
        }

        @Override
        public void updateAllNotifications() {
        }

        @Override
        public void logNotificationActionInvocation(@Nullable Key<?> providerKey, @Nullable Class<?> runnableClass) {
        }
    };

    @NotNull
    public static EditorNotifications getInstance(@NotNull Project project) {
        return project.isDefault() ? NULL_IMPL : (EditorNotifications)project.getService(EditorNotifications.class);
    }

    public abstract void updateNotifications(@NotNull VirtualFile var1);

    public abstract void updateNotifications(@NotNull Provider<?> var1);

    public abstract void updateAllNotifications();

    @ApiStatus.Internal
    public abstract void logNotificationActionInvocation(@Nullable Key<?> var1, @Nullable Class<?> var2);

    public static void updateAll() {
        Project[] projects;
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            EditorNotifications.getInstance(project).updateAllNotifications();
        }
    }

    public static abstract class Provider<T extends JComponent> {
        @NotNull
        public abstract Key<T> getKey();

        @Deprecated
        @Nullable
        public T createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
            throw new AbstractMethodError();
        }

        @Nullable
        public T createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor, @NotNull Project project) {
            return this.createNotificationPanel(file, fileEditor);
        }
    }
}

