/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsSearch;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryParameters;
import org.jetbrains.annotations.NotNull;

public final class DefinitionsScopedSearch
extends ExtensibleQueryFactory<PsiElement, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiElement, SearchParameters>> EP_NAME = ExtensionPointName.create((String)"com.intellij.definitionsScopedSearch");
    public static final DefinitionsScopedSearch INSTANCE = new DefinitionsScopedSearch();

    private DefinitionsScopedSearch() {
        super(EP_NAME);
    }

    public static Query<PsiElement> search(PsiElement definitionsOf) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf));
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope) {
        return DefinitionsScopedSearch.search(definitionsOf, searchScope, true);
    }

    public static Query<PsiElement> search(PsiElement definitionsOf, SearchScope searchScope, boolean checkDeep) {
        return INSTANCE.createUniqueResultsQuery(new SearchParameters(definitionsOf, searchScope, checkDeep));
    }

    static {
        INSTANCE.registerExecutor((queryParameters, consumer) -> {
            for (QueryExecutor executor : (QueryExecutor[])DefinitionsSearch.EP_NAME.getExtensions()) {
                if (executor.execute(queryParameters.getElement(), consumer)) continue;
                return false;
            }
            return true;
        });
    }

    public static class SearchParameters
    implements QueryParameters {
        private final PsiElement myElement;
        private final SearchScope myScope;
        private final boolean myCheckDeep;
        private final Project myProject;

        public SearchParameters(@NotNull PsiElement element) {
            this(element, (SearchScope)ReadAction.compute(element::getUseScope), true);
        }

        public SearchParameters(@NotNull PsiElement element, @NotNull SearchScope scope, boolean checkDeep) {
            this.myElement = element;
            this.myScope = scope;
            this.myCheckDeep = checkDeep;
            this.myProject = PsiUtilCore.getProjectInReadAction(this.myElement);
        }

        @NotNull
        public PsiElement getElement() {
            return this.myElement;
        }

        public boolean isCheckDeep() {
            return this.myCheckDeep;
        }

        @Override
        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        @Override
        public boolean isQueryValid() {
            return this.myElement.isValid();
        }

        @NotNull
        public SearchScope getScope() {
            return (SearchScope)ReadAction.compute(() -> {
                PsiFile file = this.myElement.getContainingFile();
                return this.myScope.intersectWith(PsiSearchHelper.getInstance(this.myElement.getProject()).getUseScope(file != null ? file : this.myElement));
            });
        }
    }
}

