/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ScopeOptimizer {
    @Deprecated
    @Nullable(value="is null when given optimizer can't provide a scope to exclude")
    default public @Nullable(value="is null when given optimizer can't provide a scope to exclude") GlobalSearchScope getScopeToExclude(@NotNull PsiElement element) {
        return null;
    }

    @Nullable(value="is null when given optimizer can't provide a scope to restrict")
    default public @Nullable(value="is null when given optimizer can't provide a scope to restrict") SearchScope getRestrictedUseScope(@NotNull PsiElement element) {
        GlobalSearchScope scopeToExclude = this.getScopeToExclude(element);
        return scopeToExclude == null ? null : GlobalSearchScope.notScope(scopeToExclude);
    }

    @Nullable
    public static SearchScope calculateOverallRestrictedUseScope(ScopeOptimizer @NotNull [] optimizers, @NotNull PsiElement element) {
        return Stream.of(optimizers).peek(optimizer -> ProgressManager.checkCanceled()).map(optimizer -> optimizer.getRestrictedUseScope(element)).filter(Objects::nonNull).reduce((s1, s2) -> s1.intersectWith((SearchScope)s2)).orElse(null);
    }
}

