/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.lang.LanguageMatcher;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalSearchScope
extends SearchScope {
    private static final Logger LOG = Logger.getInstance(LocalSearchScope.class);
    public static final LocalSearchScope EMPTY = new LocalSearchScope(PsiElement.EMPTY_ARRAY);
    private final String myDisplayName;
    private final PsiElement[] myScope;
    private final VirtualFile[] myVirtualFiles;
    private final boolean myIgnoreInjectedPsi;

    public LocalSearchScope(@NotNull PsiElement scope) {
        this(scope, null);
    }

    public LocalSearchScope(@NotNull PsiElement scope, @Nullable String displayName) {
        this(new PsiElement[]{scope}, displayName);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope) {
        this(scope, null);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope, @Nullable String displayName) {
        this(scope, displayName, false);
    }

    public LocalSearchScope(PsiElement @NotNull [] scope, @Nullable String displayName, boolean ignoreInjectedPsi) {
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
        this.myDisplayName = displayName;
        LinkedHashSet<PsiElement> localScope = new LinkedHashSet<PsiElement>(scope.length);
        THashSet virtualFiles = new THashSet(scope.length);
        for (PsiElement element : scope) {
            VirtualFile virtualFile2;
            LOG.assertTrue(element != null, (Object)"null element");
            PsiFile containingFile = element.getContainingFile();
            LOG.assertTrue(containingFile != null, (Object)element.getClass().getName());
            if (element instanceof PsiFile) {
                for (PsiFile file : ((PsiFile)element).getViewProvider().getAllFiles()) {
                    if (file == null) {
                        throw new IllegalArgumentException("file " + element + " returned null in its getAllFiles()");
                    }
                    localScope.add(file);
                }
            } else if (element instanceof StubBasedPsiElement || element.getTextRange() != null) {
                localScope.add(element);
            }
            if ((virtualFile2 = PsiUtilCore.getVirtualFile(containingFile)) == null) continue;
            virtualFiles.add(virtualFile2);
        }
        this.myScope = PsiUtilCore.toPsiElementArray(localScope);
        this.myVirtualFiles = VfsUtilCore.toVirtualFileArray((Collection<? extends VirtualFile>)virtualFiles);
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName == null ? super.getDisplayName() : this.myDisplayName;
    }

    public PsiElement @NotNull [] getScope() {
        return this.myScope;
    }

    public VirtualFile @NotNull [] getVirtualFiles() {
        return this.myVirtualFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalSearchScope)) {
            return false;
        }
        LocalSearchScope other = (LocalSearchScope)o;
        if (other.myIgnoreInjectedPsi != this.myIgnoreInjectedPsi) {
            return false;
        }
        if (other.myScope.length != this.myScope.length) {
            return false;
        }
        if (!Comparing.strEqual((String)this.myDisplayName, (String)other.myDisplayName)) {
            return false;
        }
        for (PsiElement scopeElement : this.myScope) {
            for (PsiElement thatScopeElement : other.myScope) {
                if (Comparing.equal((Object)scopeElement, (Object)thatScopeElement)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    protected int calcHashCode() {
        int result = 0;
        result += this.myIgnoreInjectedPsi ? 1 : 0;
        for (PsiElement element : this.myScope) {
            result += element.hashCode();
        }
        return result;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (this.equals(scope2)) {
            return this;
        }
        return LocalSearchScope.intersection(this, scope2);
    }

    @NotNull
    private static LocalSearchScope intersection(@NotNull LocalSearchScope scope1, @NotNull LocalSearchScope scope2) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement element1 : scope1.myScope) {
            for (PsiElement element2 : scope2.myScope) {
                PsiElement element = LocalSearchScope.intersectScopeElements(element1, element2);
                if (element == null) continue;
                result.add(element);
            }
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), null, scope1.myIgnoreInjectedPsi || scope2.myIgnoreInjectedPsi);
    }

    @Override
    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 instanceof LocalSearchScope) {
            return this.intersectWith((LocalSearchScope)scope2);
        }
        LocalSearchScope nonPhysicalScope = this.tryIntersectNonPhysicalWith((GlobalSearchScope)scope2);
        if (nonPhysicalScope != null) {
            return nonPhysicalScope;
        }
        return ((GlobalSearchScope)scope2).intersectWith(this);
    }

    @Nullable
    private LocalSearchScope tryIntersectNonPhysicalWith(@NotNull GlobalSearchScope scope) {
        Project project = scope.getProject();
        for (PsiElement element : this.myScope) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null) continue;
            if (containingFile.getViewProvider().isPhysical()) {
                return null;
            }
            if (project == null || project == containingFile.getProject()) continue;
            return EMPTY;
        }
        return this;
    }

    @Nullable
    private static PsiElement intersectScopeElements(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (PsiTreeUtil.isContextAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isContextAncestor(element2, element1, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element2;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element1;
        }
        return null;
    }

    public String toString() {
        return Arrays.stream(this.myScope).map(String::valueOf).collect(Collectors.joining(",", "LocalSearchScope:", ""));
    }

    @Override
    @NotNull
    public SearchScope union(@NotNull SearchScope scope) {
        if (scope instanceof LocalSearchScope) {
            return this.union((LocalSearchScope)scope);
        }
        return ((GlobalSearchScope)scope).union(this);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return this.isInScope(file);
    }

    @NotNull
    public SearchScope union(@NotNull LocalSearchScope scope2) {
        if (this.equals(scope2)) {
            return this;
        }
        PsiElement[] elements1 = this.getScope();
        PsiElement[] elements2 = scope2.getScope();
        boolean[] united = new boolean[elements2.length];
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        block0: for (PsiElement element1 : elements1) {
            for (int j = 0; j < elements2.length; ++j) {
                PsiElement element2 = elements2[j];
                PsiElement unionElement = LocalSearchScope.scopeElementsUnion(element1, element2);
                if (unionElement == null || unionElement.getContainingFile() == null) continue;
                result.add(unionElement);
                united[j] = true;
                break block0;
            }
            result.add(element1);
        }
        for (int i = 0; i < united.length; ++i) {
            boolean b = united[i];
            if (b) continue;
            result.add(elements2[i]);
        }
        return new LocalSearchScope(PsiUtilCore.toPsiElementArray(result));
    }

    private static PsiElement scopeElementsUnion(@NotNull PsiElement element1, @NotNull PsiElement element2) {
        if (PsiTreeUtil.isAncestor(element1, element2, false)) {
            return element1;
        }
        if (PsiTreeUtil.isAncestor(element2, element1, false)) {
            return element2;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent(element1, element2);
        if (commonParent == null) {
            return null;
        }
        return commonParent;
    }

    public boolean isInScope(@NotNull VirtualFile file) {
        return ArrayUtil.indexOf((Object[])this.myVirtualFiles, (Object)file) != -1;
    }

    public boolean containsRange(@NotNull PsiFile file, @NotNull TextRange range) {
        for (PsiElement element : this.getScope()) {
            if (file != element.getContainingFile() || !element.getTextRange().contains(range)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static LocalSearchScope getScopeRestrictedByFileTypes(@NotNull LocalSearchScope scope, FileType ... fileTypes) {
        if (fileTypes.length == 0) {
            throw new IllegalArgumentException("empty fileTypes");
        }
        if (scope == EMPTY) {
            return EMPTY;
        }
        return (LocalSearchScope)ReadAction.compute(() -> {
            PsiElement[] elements = scope.getScope();
            ArrayList<PsiElement> result = new ArrayList<PsiElement>(elements.length);
            for (PsiElement element : elements) {
                PsiFile containingFile = element.getContainingFile();
                FileType fileType = containingFile.getFileType();
                if (!ArrayUtil.contains((Object)fileType, (Object[])fileTypes)) continue;
                result.add(element);
            }
            return result.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
    }

    @Contract(pure=true)
    @NotNull
    static LocalSearchScope getScopeRestrictedByFileLanguage(@NotNull LocalSearchScope scope, @NotNull LanguageMatcher matcher) {
        if (scope == EMPTY) {
            return EMPTY;
        }
        return (LocalSearchScope)ReadAction.compute(() -> {
            List result = ContainerUtil.filter((Object[])scope.getScope(), element -> matcher.matchesLanguage(element.getContainingFile().getLanguage()));
            return result.isEmpty() ? EMPTY : new LocalSearchScope(PsiUtilCore.toPsiElementArray(result), scope.getDisplayName(), scope.isIgnoreInjectedPsi());
        });
    }
}

