/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.TestSourcesFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class GlobalSearchScopesCore {
    @NotNull
    public static GlobalSearchScope projectProductionScope(@NotNull Project project) {
        return new ProductionScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope projectTestScope(@NotNull Project project) {
        return new TestScopeFilter(project);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull PsiDirectory directory, boolean withSubdirectories) {
        return new DirectoryScope(directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
        return new DirectoryScope(project, directory, withSubdirectories);
    }

    @NotNull
    public static GlobalSearchScope directoriesScope(@NotNull Project project, boolean withSubdirectories, VirtualFile ... directories) {
        HashSet dirSet = ContainerUtil.newHashSet((Object[])directories);
        if (dirSet.isEmpty()) {
            return GlobalSearchScope.EMPTY_SCOPE;
        }
        if (dirSet.size() == 1) {
            return GlobalSearchScopesCore.directoryScope(project, (VirtualFile)dirSet.iterator().next(), withSubdirectories);
        }
        return new DirectoriesScope(project, withSubdirectories ? Collections.emptySet() : dirSet, withSubdirectories ? dirSet : Collections.emptySet());
    }

    @NotNull
    public static GlobalSearchScope filterScope(@NotNull Project project, @NotNull NamedScope set) {
        return new FilterScopeAdapter(project, set);
    }

    static class DirectoriesScope
    extends GlobalSearchScope {
        private final Set<? extends VirtualFile> myDirectories;
        private final Set<? extends VirtualFile> myDirectoriesWithSubdirectories;

        private DirectoriesScope(@NotNull Project project, @NotNull Set<? extends VirtualFile> directories, @NotNull Set<? extends VirtualFile> directoriesWithSubdirectories) {
            super(project);
            this.myDirectories = directories;
            this.myDirectoriesWithSubdirectories = directoriesWithSubdirectories;
            if (directories.size() + directoriesWithSubdirectories.size() < 2) {
                throw new IllegalArgumentException("Expected >1 directories, but got: directories " + directories + ", directories with subdirectories " + directoriesWithSubdirectories);
            }
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            if (this.myDirectories.contains(parent)) {
                return true;
            }
            return VfsUtilCore.isUnder(parent, this.myDirectoriesWithSubdirectories);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "Directories scope: directories " + this.myDirectories + ", directories with subdirectories " + this.myDirectoriesWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            int result = this.myDirectories.hashCode();
            result = result * 31 + this.myDirectoriesWithSubdirectories.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoriesScope && this.myDirectories.equals(((DirectoriesScope)obj).myDirectories) && this.myDirectoriesWithSubdirectories.equals(((DirectoriesScope)obj).myDirectoriesWithSubdirectories);
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (this.equals(scope)) {
                return this;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    return this;
                }
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (other.myWithSubdirectories) {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.add(other.myDirectory);
                    directoriesWithSubdirectories = copy;
                } else {
                    HashSet<? extends VirtualFile> copy = new HashSet<VirtualFile>(directories);
                    copy.add(other.myDirectory);
                    directories = copy;
                }
                return new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
            }
            if (scope instanceof DirectoriesScope) {
                HashSet<? extends VirtualFile> copy;
                DirectoriesScope other = (DirectoriesScope)scope;
                Set<? extends VirtualFile> directories = this.myDirectories;
                Set<? extends VirtualFile> directoriesWithSubdirectories = this.myDirectoriesWithSubdirectories;
                if (!other.myDirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directories);
                    copy.addAll(other.myDirectories);
                    directories = copy;
                }
                if (!other.myDirectoriesWithSubdirectories.isEmpty()) {
                    copy = new HashSet<VirtualFile>(directoriesWithSubdirectories);
                    copy.addAll(other.myDirectoriesWithSubdirectories);
                    directoriesWithSubdirectories = copy;
                }
                return new DirectoriesScope(this.getProject(), directories, directoriesWithSubdirectories);
            }
            return super.uniteWith(scope);
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            if (this.myDirectories.size() + this.myDirectoriesWithSubdirectories.size() == 1) {
                Set<? extends VirtualFile> dirs = this.myDirectories.size() == 1 ? this.myDirectories : this.myDirectoriesWithSubdirectories;
                VirtualFile root = (VirtualFile)Objects.requireNonNull(ContainerUtil.getFirstItem(dirs));
                return AnalysisBundle.message("display.name.directory.0", root.getName());
            }
            Iterable allDirs = ContainerUtil.concat(this.myDirectories, this.myDirectoriesWithSubdirectories);
            return AnalysisBundle.message("display.name.directories.0", StringUtil.join((Iterable)allDirs, file -> "'" + file.getName() + "'", (String)", "));
        }
    }

    public static class DirectoryScope
    extends GlobalSearchScope {
        private final VirtualFile myDirectory;
        private final boolean myWithSubdirectories;

        private DirectoryScope(@NotNull PsiDirectory psiDirectory, boolean withSubdirectories) {
            super(psiDirectory.getProject());
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = psiDirectory.getVirtualFile();
        }

        public DirectoryScope(@NotNull Project project, @NotNull VirtualFile directory, boolean withSubdirectories) {
            super(project);
            this.myWithSubdirectories = withSubdirectories;
            this.myDirectory = directory;
        }

        @NotNull
        public VirtualFile getDirectory() {
            return this.myDirectory;
        }

        public boolean isWithSubdirectories() {
            return this.myWithSubdirectories;
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            VirtualFile parent = file.getParent();
            return parent != null && this.in(parent);
        }

        private boolean in(@NotNull VirtualFile parent) {
            return this.myWithSubdirectories ? VfsUtilCore.isAncestor(this.myDirectory, parent, false) : this.myDirectory.equals(parent);
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public String toString() {
            return "directory scope: " + this.myDirectory + "; withSubdirs:" + this.myWithSubdirectories;
        }

        @Override
        public int calcHashCode() {
            return this.myDirectory.hashCode() * 31 + (this.myWithSubdirectories ? 1 : 0);
        }

        public boolean equals(Object obj) {
            return obj instanceof DirectoryScope && this.myDirectory.equals(((DirectoryScope)obj).myDirectory) && this.myWithSubdirectories == ((DirectoryScope)obj).myWithSubdirectories;
        }

        @Override
        @NotNull
        public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
            if (this.equals(scope)) {
                return this;
            }
            if (scope instanceof DirectoryScope) {
                DirectoryScope other = (DirectoryScope)scope;
                if (this.in(other.myDirectory)) {
                    return this;
                }
                if (other.in(this.myDirectory)) {
                    return other;
                }
                return new DirectoriesScope(this.getProject(), DirectoryScope.union(!this.myWithSubdirectories, this.myDirectory, !other.myWithSubdirectories, other.myDirectory), DirectoryScope.union(this.myWithSubdirectories, this.myDirectory, other.myWithSubdirectories, other.myDirectory));
            }
            return super.uniteWith(scope);
        }

        @NotNull
        private static Set<VirtualFile> union(boolean addDir1, @NotNull VirtualFile dir1, boolean addDir2, @NotNull VirtualFile dir2) {
            if (addDir1 && addDir2) {
                return ContainerUtil.newHashSet((Object[])new VirtualFile[]{dir1, dir2});
            }
            if (addDir1) {
                return Collections.singleton(dir1);
            }
            if (addDir2) {
                return Collections.singleton(dir2);
            }
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return AnalysisBundle.message("display.name.directory.0", this.myDirectory.getName());
        }
    }

    private static class TestScopeFilter
    extends GlobalSearchScope {
        private TestScopeFilter(@NotNull Project project) {
            super(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return TestSourcesFilter.isTestSources(file, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return AnalysisBundle.message("psi.search.scope.test.files", new Object[0]);
        }
    }

    private static class ProductionScopeFilter
    extends GlobalSearchScope {
        private final ProjectFileIndex myFileIndex;

        private ProductionScopeFilter(@NotNull Project project) {
            super(project);
            this.myFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            return this.myFileIndex.isInSourceContent(file) && !TestSourcesFilter.isTestSources(file, Objects.requireNonNull(this.getProject()));
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule, boolean testSources) {
            return !testSources;
        }

        @Override
        public boolean isSearchInLibraries() {
            return false;
        }

        @Override
        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            return ModuleManager.getInstance(Objects.requireNonNull(this.getProject())).getUnloadedModuleDescriptions();
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return AnalysisBundle.message("psi.search.scope.production.files", new Object[0]);
        }
    }

    private static class FilterScopeAdapter
    extends GlobalSearchScope {
        private final NamedScope mySet;
        private final PsiManager myManager;

        private FilterScopeAdapter(@NotNull Project project, @NotNull NamedScope set) {
            super(project);
            this.mySet = set;
            this.myManager = PsiManager.getInstance(project);
        }

        @Override
        public boolean contains(@NotNull VirtualFile file) {
            Project project = this.getProject();
            NamedScopeManager holder = NamedScopeManager.getInstance(project);
            PackageSet packageSet = this.mySet.getValue();
            if (packageSet != null) {
                if (packageSet instanceof PackageSetBase) {
                    return ((PackageSetBase)packageSet).contains(file, project, holder);
                }
                PsiFile psiFile = this.myManager.findFile(file);
                return psiFile != null && packageSet.contains(psiFile, holder);
            }
            return false;
        }

        @Override
        @NotNull
        public String getDisplayName() {
            return this.mySet.getName();
        }

        @Override
        @NotNull
        public Icon getIcon() {
            return this.mySet.getIcon();
        }

        @Override
        @NotNull
        public Project getProject() {
            return super.getProject();
        }

        @Override
        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            return true;
        }

        @Override
        public boolean isSearchInLibraries() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterScopeAdapter adapter = (FilterScopeAdapter)o;
            if (!this.mySet.equals(adapter.mySet)) {
                return false;
            }
            return ((Object)((Object)this.myManager)).equals((Object)adapter.myManager);
        }

        @Override
        public int calcHashCode() {
            int result = super.calcHashCode();
            result = 31 * result + this.mySet.hashCode();
            result = 31 * result + ((Object)((Object)this.myManager)).hashCode();
            return result;
        }

        public String toString() {
            return "FilterScope adapted from " + this.mySet;
        }
    }
}

