/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageMatcher;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class FileLanguageGlobalScope
extends DelegatingGlobalSearchScope {
    private final Project myProject;
    private final Collection<LanguageMatcher> myLanguageMatchers;

    FileLanguageGlobalScope(@NotNull Project project, @NotNull GlobalSearchScope baseScope, @NotNull Collection<LanguageMatcher> languageMatchers) {
        super(baseScope);
        this.myProject = project;
        this.myLanguageMatchers = languageMatchers;
    }

    FileLanguageGlobalScope(Project project, GlobalSearchScope scope, LanguageMatcher matcher) {
        this(project, scope, Collections.singleton(matcher));
    }

    @Override
    public boolean contains(@NotNull VirtualFile file) {
        return super.contains(file) && this.matchesLanguage(file);
    }

    private boolean matchesLanguage(@NotNull VirtualFile file) {
        Language baseLanguage = LanguageUtil.getLanguageForPsi(this.myProject, file);
        if (baseLanguage instanceof TemplateLanguage) {
            FileViewProvider viewProvider = PsiManager.getInstance(this.myProject).findViewProvider(file);
            if (viewProvider == null) {
                return false;
            }
            return ContainerUtil.or(viewProvider.getLanguages(), fileLanguage -> ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage((Language)((Object)fileLanguage))));
        }
        if (baseLanguage != null) {
            return ContainerUtil.or(this.myLanguageMatchers, matcher -> matcher.matchesLanguage(baseLanguage));
        }
        return false;
    }

    @Override
    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope;
            if (this.myBaseScope == other.myBaseScope) {
                Collection intersection = ContainerUtil.intersection(this.myLanguageMatchers, other.myLanguageMatchers);
                if (intersection.isEmpty()) {
                    return GlobalSearchScope.EMPTY_SCOPE;
                }
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        return super.intersectWith(scope);
    }

    @Override
    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope instanceof FileLanguageGlobalScope) {
            FileLanguageGlobalScope other = (FileLanguageGlobalScope)scope;
            if (this.myBaseScope == other.myBaseScope) {
                Set intersection = ContainerUtil.union(this.myLanguageMatchers, other.myLanguageMatchers);
                return new FileLanguageGlobalScope(this.myProject, this.myBaseScope, intersection);
            }
        }
        return super.uniteWith(scope);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileLanguageGlobalScope scope = (FileLanguageGlobalScope)o;
        if (!this.myProject.equals(scope.myProject)) {
            return false;
        }
        return this.myLanguageMatchers.equals(scope.myLanguageMatchers);
    }

    @Override
    public int calcHashCode() {
        int result = super.calcHashCode();
        result = 31 * result + this.myProject.hashCode();
        result = 31 * result + this.myLanguageMatchers.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "(restricted by file languages: " + this.myLanguageMatchers + " in " + this.myBaseScope + ")";
    }
}

