/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.processor;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.differ.LangCodeStyleExtractor;
import com.intellij.psi.codeStyle.extractor.processor.CodeStyleDeriveProcessor;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

public class GenProcessor
extends CodeStyleDeriveProcessor {
    private String myReport = "No result";

    public GenProcessor(LangCodeStyleExtractor langExtractor) {
        super(langExtractor);
    }

    @Override
    public Gens runWithProgress(Project project, CodeStyleSettings settings, PsiFile file, ProgressIndicator indicator) {
        Gens origGens = new Gens(this.getFormattingValues(settings, file.getLanguage()));
        Gens forSelection = origGens.copy();
        Differ differ = this.myLangExtractor.getDiffer(project, file, settings);
        forSelection.dropToInitial();
        long startTime = System.nanoTime();
        Utils.adjustValuesGA(forSelection, differ, indicator);
        this.myReport = "<br> Genetic phase: " + GenProcessor.reportResult(forSelection, differ, startTime);
        startTime = System.nanoTime();
        Utils.adjustValuesMin(forSelection, differ, indicator);
        this.myReport = this.myReport + "<br> Minimization Phase: " + GenProcessor.reportResult(forSelection, differ, startTime);
        return forSelection;
    }

    @Override
    @NotNull
    public String getHTMLReport() {
        return this.myReport;
    }

    @NotNull
    private static String reportResult(@NotNull Gens gens, @NotNull Differ differ, long startTime) {
        SimpleDateFormat formatter = new SimpleDateFormat("mm:ss");
        Date date = new Date((System.nanoTime() - startTime) / 1000000L);
        return "Difference in spaces with the original:" + differ.getDifference(gens) + " Execution Time:" + formatter.format(date);
    }
}

