/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public final class ElementDescriptionUtil {
    private ElementDescriptionUtil() {
    }

    @NotNull
    public static String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String result;
        for (ElementDescriptionProvider provider : ElementDescriptionProvider.EP_NAME.getExtensionList()) {
            String result2 = provider.getElementDescription(element, location);
            if (result2 == null) continue;
            return result2;
        }
        ElementDescriptionProvider defaultProvider = location.getDefaultProvider();
        if (defaultProvider != null && (result = defaultProvider.getElementDescription(element, location)) != null) {
            return result;
        }
        return element.toString();
    }
}

