/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.wm.FocusRequestor;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.PassThroughIdeFocusManager;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IdeFocusManager
implements FocusRequestor {
    public ActionCallback requestFocusInProject(@NotNull Component c, @Nullable Project project) {
        return this.requestFocus(c, false);
    }

    @Nullable
    public abstract JComponent getFocusTargetFor(@NotNull JComponent var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1);

    public abstract void doWhenFocusSettlesDown(@NotNull Runnable var1, @NotNull ModalityState var2);

    public abstract void doWhenFocusSettlesDown(@NotNull ExpirableRunnable var1);

    @Nullable
    public abstract Component getFocusedDescendantFor(@NotNull Component var1);

    @Deprecated
    public void typeAheadUntil(ActionCallback done) {
        this.typeAheadUntil(done, "No cause has been provided");
    }

    public void typeAheadUntil(ActionCallback done, @NotNull String cause) {
    }

    @NotNull
    public ActionCallback requestDefaultFocus(boolean forced) {
        return ActionCallback.DONE;
    }

    public abstract boolean isFocusTransferEnabled();

    public abstract void setTypeaheadEnabled(boolean var1);

    public abstract Component getFocusOwner();

    public abstract void runOnOwnContext(@NotNull DataContext var1, @NotNull Runnable var2);

    @Nullable
    public abstract Component getLastFocusedFor(@Nullable Window var1);

    @Nullable
    public abstract IdeFrame getLastFocusedFrame();

    @Nullable
    public abstract Window getLastFocusedIdeWindow();

    public abstract void toFront(JComponent var1);

    public static IdeFocusManager getInstance(@Nullable Project project) {
        Application app = ApplicationManager.getApplication();
        if (app == null || app.isHeadlessEnvironment() || app.isUnitTestMode() || project == null || project.isDisposed() || !project.isInitialized()) {
            return IdeFocusManager.getGlobalInstance();
        }
        return (IdeFocusManager)project.getService(IdeFocusManager.class);
    }

    @NotNull
    public static IdeFocusManager findInstanceByContext(@Nullable DataContext context) {
        IdeFocusManager instance = null;
        if (context != null) {
            instance = IdeFocusManager.getInstanceSafe(CommonDataKeys.PROJECT.getData(context));
        }
        if (instance == null) {
            instance = IdeFocusManager.findByComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow());
        }
        if (instance == null) {
            instance = IdeFocusManager.getGlobalInstance();
        }
        return instance;
    }

    @NotNull
    public static IdeFocusManager findInstanceByComponent(@NotNull Component component) {
        IdeFocusManager instance = IdeFocusManager.findByComponent(component);
        return instance == null ? IdeFocusManager.findInstanceByContext(null) : instance;
    }

    @Nullable
    private static IdeFocusManager findByComponent(@Nullable Component component) {
        if (component == null) {
            return null;
        }
        Component parent = ComponentUtil.findUltimateParent((Component)component);
        return parent instanceof IdeFrame ? IdeFocusManager.getInstanceSafe(((IdeFrame)((Object)parent)).getProject()) : null;
    }

    @Nullable
    private static IdeFocusManager getInstanceSafe(@Nullable Project project) {
        if (project != null && !project.isDisposed() && project.isInitialized()) {
            return IdeFocusManager.getInstance(project);
        }
        return null;
    }

    @NotNull
    public static IdeFocusManager findInstance() {
        Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        return owner != null ? IdeFocusManager.findInstanceByComponent(owner) : IdeFocusManager.findInstanceByContext(null);
    }

    @Deprecated
    @NotNull
    public FocusRequestor getFurtherRequestor() {
        return new FocusRequestor(){

            @Override
            @NotNull
            public ActionCallback requestFocus(@NotNull Component c, boolean forced) {
                return ActionCallback.REJECTED;
            }

            public void dispose() {
            }
        };
    }

    @NotNull
    public static IdeFocusManager getGlobalInstance() {
        IdeFocusManager focusManager = null;
        Application app = ApplicationManager.getApplication();
        if (app != null && LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            focusManager = (IdeFocusManager)app.getService(IdeFocusManager.class);
        }
        if (focusManager == null) {
            focusManager = PassThroughIdeFocusManager.getInstance();
        }
        return focusManager;
    }

    public void dispose() {
    }
}

