/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.util.text.CharArrayUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFile
extends UserDataHolderBase
implements ModificationTracker {
    public static final VirtualFile[] EMPTY_ARRAY = new VirtualFile[0];
    public static final String PROP_NAME = "name";
    public static final String PROP_ENCODING = "encoding";
    public static final String PROP_WRITABLE = "writable";
    public static final String PROP_HIDDEN = "HIDDEN";
    public static final String PROP_SYMLINK_TARGET = "symlink";
    private static final Logger LOG = Logger.getInstance(VirtualFile.class);
    private static final Key<byte[]> BOM_KEY = Key.create((String)"BOM");
    private static final Key<Charset> CHARSET_KEY = Key.create((String)"CHARSET");
    private static final Key<String> DETECTED_LINE_SEPARATOR_KEY = Key.create((String)"DETECTED_LINE_SEPARATOR_KEY");

    protected VirtualFile() {
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public CharSequence getNameSequence() {
        return this.getName();
    }

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    @NotNull
    public abstract String getPath();

    @NotNull
    public Path toNioPath() {
        Path path2 = this.getFileSystem().getNioPath(this);
        if (path2 == null) {
            throw new UnsupportedOperationException("Failed to map " + this + " (filesystem " + this.getFileSystem() + ") into nio Path");
        }
        return path2;
    }

    @NotNull
    public String getUrl() {
        return VirtualFileManager.constructUrl(this.getFileSystem().getProtocol(), this.getPath());
    }

    @NotNull
    public final String getPresentableUrl() {
        return this.getFileSystem().extractPresentableUrl(this.getPath());
    }

    @Nullable
    public String getExtension() {
        CharSequence extension = FileUtilRt.getExtension((CharSequence)this.getNameSequence(), null);
        return extension == null ? null : extension.toString();
    }

    @NotNull
    public String getNameWithoutExtension() {
        return FileUtilRt.getNameWithoutExtension((CharSequence)this.getNameSequence()).toString();
    }

    public void rename(Object requestor, @NotNull @NonNls String newName) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getName().equals(newName)) {
            return;
        }
        if (!this.getFileSystem().isValidName(newName)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", newName));
        }
        this.getFileSystem().renameFile(requestor, this, newName);
    }

    public abstract boolean isWritable();

    public void setWritable(boolean writable) throws IOException {
        throw new IOException("Not supported");
    }

    public abstract boolean isDirectory();

    public boolean is(@NotNull VFileProperty property) {
        return false;
    }

    @Nullable
    public String getCanonicalPath() {
        return this.getPath();
    }

    @Nullable
    public VirtualFile getCanonicalFile() {
        return this;
    }

    public abstract boolean isValid();

    public abstract VirtualFile getParent();

    public abstract VirtualFile[] getChildren();

    @Nullable
    public VirtualFile findChild(@NotNull @NonNls String name) {
        VirtualFile[] children = this.getChildren();
        if (children == null) {
            return null;
        }
        for (VirtualFile child : children) {
            if (!child.nameEquals(name)) continue;
            return child;
        }
        return null;
    }

    @NotNull
    public VirtualFile findOrCreateChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        VirtualFile child = this.findChild(name);
        if (child != null) {
            return child;
        }
        return this.createChildData(requestor, name);
    }

    @NotNull
    public FileType getFileType() {
        return FileTypeRegistry.getInstance().getFileTypeByFile(this);
    }

    @Nullable
    public VirtualFile findFileByRelativePath(@NotNull @NonNls String relPath) {
        VirtualFile child = this;
        int off = CharArrayUtil.shiftForward((CharSequence)relPath, (int)0, (String)"/");
        while (child != null && off < relPath.length()) {
            String name;
            int nextOff = relPath.indexOf(47, off);
            if (nextOff < 0) {
                nextOff = relPath.length();
            }
            if ((name = relPath.substring(off, nextOff)).equals("..")) {
                VirtualFile canonicalFile;
                child = child.is(VFileProperty.SYMLINK) ? ((canonicalFile = child.getCanonicalFile()) != null ? canonicalFile.getParent() : null) : child.getParent();
            } else if (!name.equals(".")) {
                child = child.findChild(name);
            }
            off = CharArrayUtil.shiftForward((CharSequence)relPath, (int)nextOff, (String)"/");
        }
        return child;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(CoreBundle.message("directory.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(CoreBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(CoreBundle.message("directory.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(CoreBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildDirectory(requestor, this, name);
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull @NonNls String name) throws IOException {
        if (!this.isDirectory()) {
            throw new IOException(CoreBundle.message("file.create.wrong.parent.error", new Object[0]));
        }
        if (!this.isValid()) {
            throw new IOException(CoreBundle.message("invalid.directory.create.files", new Object[0]));
        }
        if (!this.getFileSystem().isValidName(name)) {
            throw new IOException(CoreBundle.message("file.invalid.name.error", name));
        }
        if (this.findChild(name) != null) {
            throw new IOException(CoreBundle.message("file.create.already.exists.error", this.getUrl(), name));
        }
        return this.getFileSystem().createChildFile(requestor, this, name);
    }

    public void delete(Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LOG.assertTrue(this.isValid(), (Object)"Deleting invalid file");
        this.getFileSystem().deleteFile(requestor, this);
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message("file.move.error", newParent.getPresentableUrl()));
        }
        EncodingRegistry.doActionAndRestoreEncoding(this, () -> {
            this.getFileSystem().moveFile(requestor, this, newParent);
            return this;
        });
    }

    @NotNull
    public VirtualFile copy(Object requestor, @NotNull VirtualFile newParent, @NotNull @NonNls String copyName) throws IOException {
        if (this.getFileSystem() != newParent.getFileSystem()) {
            throw new IOException(CoreBundle.message("file.copy.error", newParent.getPresentableUrl()));
        }
        if (!newParent.isDirectory()) {
            throw new IOException(CoreBundle.message("file.copy.target.must.be.directory", new Object[0]));
        }
        return EncodingRegistry.doActionAndRestoreEncoding(this, () -> this.getFileSystem().copyFile(requestor, this, newParent, copyName));
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.getStoredCharset();
        if (charset == null) {
            charset = EncodingRegistry.getInstance().getDefaultCharset();
            this.setCharset(charset);
        }
        return charset;
    }

    @Nullable
    private Charset getStoredCharset() {
        return (Charset)this.getUserData(CHARSET_KEY);
    }

    protected void storeCharset(Charset charset) {
        this.putUserData(CHARSET_KEY, charset);
    }

    public void setCharset(Charset charset) {
        this.setCharset(charset, null);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged) {
        this.setCharset(charset, whenChanged, true);
    }

    public void setCharset(Charset charset, @Nullable Runnable whenChanged, boolean fireEventsWhenChanged) {
        Charset old = this.getStoredCharset();
        this.storeCharset(charset);
        if (Comparing.equal((Object)charset, (Object)old)) {
            return;
        }
        byte[] bom = charset == null ? null : CharsetToolkit.getMandatoryBom((Charset)charset);
        byte[] existingBOM = this.getBOM();
        if (bom == null && charset != null && existingBOM != null) {
            bom = (byte[])(CharsetToolkit.canHaveBom((Charset)charset, (byte[])existingBOM) ? existingBOM : null);
        }
        this.setBOM(bom);
        if (old != null) {
            if (whenChanged != null) {
                whenChanged.run();
            }
            if (fireEventsWhenChanged) {
                VirtualFileManager.getInstance().notifyPropertyChanged(this, PROP_ENCODING, old, charset);
            }
        }
    }

    public boolean isCharsetSet() {
        return this.getStoredCharset() != null;
    }

    public final void setBinaryContent(byte @NotNull [] content) throws IOException {
        this.setBinaryContent(content, -1L, -1L);
    }

    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp) throws IOException {
        this.setBinaryContent(content, newModificationStamp, newTimeStamp, this);
    }

    public void setBinaryContent(byte @NotNull [] content, long newModificationStamp, long newTimeStamp, Object requestor) throws IOException {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        try (OutputStream outputStream = this.getOutputStream(requestor, newModificationStamp, newTimeStamp);){
            outputStream.write(content);
            outputStream.flush();
        }
    }

    public final OutputStream getOutputStream(Object requestor) throws IOException {
        return this.getOutputStream(requestor, -1L, -1L);
    }

    @NotNull
    public abstract OutputStream getOutputStream(Object var1, long var2, long var4) throws IOException;

    public abstract byte @NotNull [] contentsToByteArray() throws IOException;

    public byte @NotNull [] contentsToByteArray(boolean cacheContent) throws IOException {
        return this.contentsToByteArray();
    }

    public long getModificationStamp() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public abstract long getTimeStamp();

    public abstract long getLength();

    public void refresh(boolean asynchronous, boolean recursive) {
        this.refresh(asynchronous, recursive, null);
    }

    public abstract void refresh(boolean var1, boolean var2, @Nullable Runnable var3);

    public String getPresentableName() {
        return this.getName();
    }

    @Override
    public long getModificationCount() {
        return this.isValid() ? this.getTimeStamp() : -1L;
    }

    protected boolean nameEquals(@NotNull @NonNls String name) {
        return Comparing.equal((CharSequence)this.getNameSequence(), (CharSequence)name);
    }

    public abstract InputStream getInputStream() throws IOException;

    public byte @Nullable [] getBOM() {
        return (byte[])this.getUserData(BOM_KEY);
    }

    public void setBOM(byte @Nullable [] BOM) {
        this.putUserData(BOM_KEY, BOM);
    }

    public String toString() {
        return "VirtualFile: " + this.getPresentableUrl();
    }

    public boolean exists() {
        return this.isValid();
    }

    public boolean isInLocalFileSystem() {
        return false;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static boolean isValidName(@NotNull String name) {
        return !name.isEmpty() && name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    @Nullable
    public String getDetectedLineSeparator() {
        return (String)this.getUserData(DETECTED_LINE_SEPARATOR_KEY);
    }

    public void setDetectedLineSeparator(@Nullable String separator) {
        this.putUserData(DETECTED_LINE_SEPARATOR_KEY, separator);
    }

    public void setPreloadedContentHint(byte[] preloadedContentHint) {
    }

    public boolean isRecursiveOrCircularSymlink() {
        if (!this.is(VFileProperty.SYMLINK)) {
            return false;
        }
        VirtualFile resolved = this.getCanonicalFile();
        if (resolved == null) {
            return false;
        }
        if (VfsUtilCore.isAncestor(resolved, this, false)) {
            return true;
        }
        for (VirtualFile p = this.getParent(); p != null; p = p.getParent()) {
            VirtualFile parentResolved;
            if (!p.is(VFileProperty.SYMLINK) || !resolved.equals(parentResolved = p.getCanonicalFile())) continue;
            return true;
        }
        return false;
    }

    public static @interface PropName {
    }
}

