/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.core.CoreBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DistinctRootsCollection;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsUtilCore {
    private static final Logger LOG = Logger.getInstance(VfsUtilCore.class);
    private static final String MAILTO = "mailto";
    public static final String LOCALHOST_URI_PATH_PREFIX = "localhost/";
    public static final char VFS_SEPARATOR_CHAR = '/';
    public static final String VFS_SEPARATOR = "/";
    private static final String PROTOCOL_DELIMITER = ":";

    public static boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile file, boolean strict) {
        VirtualFile parent;
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return false;
        }
        VirtualFile virtualFile2 = parent = strict ? file.getParent() : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public static boolean isUnder(@NotNull VirtualFile file, @Nullable Set<? extends VirtualFile> roots) {
        if (roots == null || roots.isEmpty()) {
            return false;
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUnder(@NotNull @NonNls String url, @Nullable @NonNls Collection<String> rootUrls) {
        if (rootUrls == null || rootUrls.isEmpty()) {
            return false;
        }
        for (String excludesUrl : rootUrls) {
            if (!VfsUtilCore.isEqualOrAncestor(excludesUrl, url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqualOrAncestor(@NotNull @NonNls String ancestorUrl, @NotNull @NonNls String fileUrl) {
        if (ancestorUrl.equals(fileUrl)) {
            return true;
        }
        if (StringUtil.endsWithChar((CharSequence)ancestorUrl, (char)'/')) {
            return fileUrl.startsWith(ancestorUrl);
        }
        return StringUtil.startsWithConcatenation((String)fileUrl, (String[])new String[]{ancestorUrl, VFS_SEPARATOR});
    }

    public static boolean isAncestor(@NotNull File ancestor, @NotNull File file, boolean strict) {
        return FileUtil.isAncestor((File)ancestor, (File)file, (boolean)strict);
    }

    @Nullable
    public static String getRelativeLocation(@Nullable VirtualFile file, @NotNull VirtualFile root) {
        if (file == null) {
            return null;
        }
        String path2 = VfsUtilCore.getRelativePath(file, root);
        return path2 != null ? path2 : file.getPresentableUrl();
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor) {
        return VfsUtilCore.getRelativePath(file, ancestor, '/');
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile file, @NotNull VirtualFile ancestor, char separator) {
        if (!file.getFileSystem().equals(ancestor.getFileSystem())) {
            return null;
        }
        int length = 0;
        VirtualFile parent = file;
        while (true) {
            if (parent == null) {
                return null;
            }
            if (parent.equals(ancestor)) break;
            if (length > 0) {
                ++length;
            }
            length += parent.getNameSequence().length();
            parent = parent.getParent();
        }
        char[] chars = new char[length];
        int index = chars.length;
        parent = file;
        while (!parent.equals(ancestor)) {
            if (index < length) {
                chars[--index] = separator;
            }
            CharSequence name = parent.getNameSequence();
            for (int i = name.length() - 1; i >= 0; --i) {
                chars[--index] = name.charAt(i);
            }
            parent = parent.getParent();
        }
        return StringFactory.createShared((char[])chars);
    }

    @Nullable
    public static String findRelativePath(@NotNull VirtualFile src, @NotNull VirtualFile dst, char separatorChar) {
        if (!src.getFileSystem().equals(dst.getFileSystem())) {
            return null;
        }
        if (!src.isDirectory() && (src = src.getParent()) == null) {
            return null;
        }
        VirtualFile commonAncestor = VfsUtilCore.getCommonAncestor(src, dst);
        if (commonAncestor == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (!Comparing.equal((Object)src, (Object)commonAncestor)) {
            while (!Comparing.equal((Object)src, (Object)commonAncestor)) {
                buffer.append("..").append(separatorChar);
                src = src.getParent();
            }
        }
        buffer.append(VfsUtilCore.getRelativePath(dst, commonAncestor, separatorChar));
        if (StringUtil.endsWithChar((CharSequence)buffer, (char)separatorChar)) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    @Nullable
    public static VirtualFile getVirtualFileForJar(@Nullable VirtualFile entryVFile) {
        if (entryVFile == null) {
            return null;
        }
        String path2 = entryVFile.getPath();
        int separatorIndex = path2.indexOf("!/");
        if (separatorIndex < 0) {
            return null;
        }
        String localPath = path2.substring(0, separatorIndex);
        return VirtualFileManager.getInstance().findFileByUrl("file://" + localPath);
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir) throws IOException {
        return VfsUtilCore.copyFile(requestor, file, toDir, file.getName());
    }

    @NotNull
    public static VirtualFile copyFile(Object requestor, @NotNull VirtualFile file, @NotNull VirtualFile toDir, @NotNull @NonNls String newName) throws IOException {
        VirtualFile newChild = toDir.createChildData(requestor, newName);
        newChild.setBOM(file.getBOM());
        newChild.setBinaryContent(file.contentsToByteArray(), -1L, -1L, requestor);
        return newChild;
    }

    @NotNull
    public static InputStream byteStreamSkippingBOM(byte @NotNull [] buf, @NotNull VirtualFile file) throws IOException {
        BufferExposingByteArrayInputStream stream = new BufferExposingByteArrayInputStream(buf);
        return VfsUtilCore.inputStreamSkippingBOM((InputStream)stream, file);
    }

    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream, @NotNull VirtualFile file) throws IOException {
        return CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
    }

    @NotNull
    public static OutputStream outputStreamAddingBOM(@NotNull OutputStream stream, @NotNull VirtualFile file) throws IOException {
        byte[] bom = file.getBOM();
        if (bom != null) {
            stream.write(bom);
        }
        return stream;
    }

    public static boolean iterateChildrenRecursively(@NotNull VirtualFile root, @Nullable VirtualFileFilter filter, @NotNull ContentIterator iterator) {
        return VfsUtilCore.iterateChildrenRecursively(root, filter, iterator, new VirtualFileVisitor.Option[0]);
    }

    public static boolean iterateChildrenRecursively(final @NotNull VirtualFile root, final @Nullable VirtualFileFilter filter, final @NotNull ContentIterator iterator, VirtualFileVisitor.Option ... options) {
        VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(options){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (filter != null && !filter.accept(file)) {
                    return SKIP_CHILDREN;
                }
                if (!iterator.processFile(file)) {
                    return 1.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return !Comparing.equal((Object)result.skipToParent, (Object)root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor) throws VirtualFileVisitor.VisitorException {
        ProgressManager.checkCanceled();
        boolean pushed = false;
        try {
            boolean allowVisitFile = visitor.allowVisitFile(file);
            if (allowVisitFile) {
                VirtualFileVisitor.Result result = visitor.visitFileEx(file);
                if (result.skipChildren) {
                    VirtualFileVisitor.Result result2 = result;
                    return result2;
                }
            }
            Iterable<VirtualFile> childrenIterable = null;
            VirtualFile[] children = null;
            try {
                if (file.isValid() && visitor.allowVisitChildren(file) && !visitor.depthLimitReached() && (childrenIterable = visitor.getChildrenIterable(file)) == null) {
                    children = file.getChildren();
                }
            }
            catch (InvalidVirtualFileAccessException e) {
                LOG.info("Ignoring: " + e.getMessage());
                VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
                visitor.restoreValue(pushed);
                return result;
            }
            if (childrenIterable != null) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : childrenIterable) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result3 = result;
                    return result3;
                }
            } else if (children != null && children.length != 0) {
                visitor.saveValue();
                pushed = true;
                for (VirtualFile child : children) {
                    VirtualFileVisitor.Result result = VfsUtilCore.visitChildrenRecursively(child, visitor);
                    if (result.skipToParent == null || Comparing.equal((Object)result.skipToParent, (Object)child)) continue;
                    VirtualFileVisitor.Result result4 = result;
                    return result4;
                }
            }
            if (allowVisitFile) {
                visitor.afterChildrenVisited(file);
            }
            VirtualFileVisitor.Result result = VirtualFileVisitor.CONTINUE;
            return result;
        }
        finally {
            visitor.restoreValue(pushed);
        }
    }

    public static <E extends Exception> VirtualFileVisitor.Result visitChildrenRecursively(@NotNull VirtualFile file, @NotNull VirtualFileVisitor<?> visitor, @NotNull Class<E> eClass) throws E {
        try {
            return VfsUtilCore.visitChildrenRecursively(file, visitor);
        }
        catch (VirtualFileVisitor.VisitorException e) {
            Throwable cause = e.getCause();
            if (eClass.isInstance(cause)) {
                throw (Exception)eClass.cast(cause);
            }
            throw e;
        }
    }

    public static boolean isBrokenLink(@NotNull VirtualFile file) {
        return file.is(VFileProperty.SYMLINK) && file.getCanonicalPath() == null;
    }

    public static boolean isInvalidLink(@NotNull VirtualFile link) {
        VirtualFile target = link.getCanonicalFile();
        return target == null || target.equals(link) || VfsUtilCore.isAncestor(target, link, true);
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file) throws IOException {
        return VfsUtilCore.loadText(file, (int)file.getLength());
    }

    @NotNull
    public static String loadText(@NotNull VirtualFile file, int length) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), file.getCharset());){
            String string = StringFactory.createShared((char[])FileUtil.loadText((Reader)reader, (int)length));
            return string;
        }
    }

    public static byte @NotNull [] loadBytes(@NotNull VirtualFile file) throws IOException {
        return FileUtilRt.isTooLarge((long)file.getLength()) ? FileUtil.loadFirstAndClose((InputStream)file.getInputStream(), (int)FileUtilRt.LARGE_FILE_PREVIEW_SIZE) : file.contentsToByteArray();
    }

    public static VirtualFile @NotNull [] toVirtualFileArray(@NotNull Collection<? extends VirtualFile> files) {
        return files.isEmpty() ? VirtualFile.EMPTY_ARRAY : files.toArray(VirtualFile.EMPTY_ARRAY);
    }

    @NotNull
    public static String urlToPath(@Nullable String url) {
        return url == null ? "" : VirtualFileManager.extractPath(url);
    }

    @NotNull
    public static File virtualToIoFile(@NotNull VirtualFile file) {
        return new File(PathUtil.toPresentableUrl(file.getUrl()));
    }

    @NotNull
    public static String pathToUrl(@NotNull String path2) {
        return VirtualFileManager.constructUrl("file", FileUtil.toSystemIndependentName((String)path2));
    }

    @NotNull
    public static String fileToUrl(@NotNull File file) {
        return VfsUtilCore.pathToUrl(file.getPath());
    }

    public static List<File> virtualToIoFiles(@NotNull Collection<? extends VirtualFile> files) {
        return ContainerUtil.map2List(files, file -> VfsUtilCore.virtualToIoFile(file));
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, true);
    }

    @NotNull
    public static String toIdeaUrl(@NotNull String url, boolean removeLocalhostPrefix) {
        int index = url.indexOf(":/");
        if (index < 0 || index + 2 >= url.length()) {
            return url;
        }
        if (url.charAt(index + 2) != '/') {
            String prefix = url.substring(0, index);
            String suffix = url.substring(index + 2);
            if (SystemInfo.isWindows) {
                return prefix + "://" + suffix;
            }
            if (removeLocalhostPrefix && prefix.equals("file") && suffix.startsWith(LOCALHOST_URI_PATH_PREFIX)) {
                return prefix + ":///" + suffix.substring(LOCALHOST_URI_PATH_PREFIX.length());
            }
            return prefix + ":///" + suffix;
        }
        if (SystemInfo.isWindows && index + 3 < url.length() && url.charAt(index + 3) == '/' && url.regionMatches(0, "file://", 0, "file://".length())) {
            char c;
            for (int i = index + 4; i < url.length() && (c = url.charAt(i)) != '/'; ++i) {
                if (c != ':') continue;
                return "file://" + url.substring(index + 4);
            }
            return url;
        }
        return url;
    }

    @NotNull
    public static String fixURLforIDEA(@NotNull String url) {
        return VfsUtilCore.toIdeaUrl(url, false);
    }

    @NotNull
    public static String convertFromUrl(@NotNull URL url) {
        String protocol = url.getProtocol();
        String path2 = url.getPath();
        if (protocol.equals("jar")) {
            if (StringUtil.startsWithConcatenation((String)path2, (String[])new String[]{"file", PROTOCOL_DELIMITER})) {
                try {
                    URL subURL = new URL(path2);
                    path2 = subURL.getPath();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(CoreBundle.message("url.parse.unhandled.exception", new Object[0]), e);
                }
            } else {
                throw new RuntimeException(new IOException(CoreBundle.message("url.parse.error", url.toExternalForm())));
            }
        }
        if (SystemInfo.isWindows) {
            while (!path2.isEmpty() && path2.charAt(0) == '/') {
                path2 = path2.substring(1);
            }
        }
        path2 = URLUtil.unescapePercentSequences((String)path2);
        return protocol + "://" + path2;
    }

    @Nullable
    public static URL convertToURL(@NotNull String vfsUrl) {
        if (vfsUrl.startsWith("jar://")) {
            try {
                return new URL("jar:file:///" + vfsUrl.substring("jar://".length()));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (vfsUrl.startsWith(MAILTO)) {
            try {
                return new URL(vfsUrl);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        String[] split2 = vfsUrl.split("://");
        if (split2.length != 2) {
            LOG.debug("Malformed VFS URL: " + vfsUrl);
            return null;
        }
        String protocol = split2[0];
        String path2 = split2[1];
        try {
            if (protocol.equals("file")) {
                return new URL("file", "", path2);
            }
            return UrlClassLoader.internProtocol((URL)new URL(vfsUrl));
        }
        catch (MalformedURLException e) {
            LOG.debug("MalformedURLException occurred:" + e.getMessage());
            return null;
        }
    }

    @NotNull
    public static String fixIDEAUrl(@NotNull String ideaUrl) {
        String ideaProtocolMarker = "://";
        int idx = ideaUrl.indexOf("://");
        if (idx >= 0) {
            String s = ideaUrl.substring(0, idx);
            if (s.equals("jar")) {
                s = "jar:file";
            }
            String urlWithoutProtocol = ideaUrl.substring(idx + "://".length());
            ideaUrl = s + PROTOCOL_DELIMITER + (urlWithoutProtocol.startsWith(VFS_SEPARATOR) ? "" : VFS_SEPARATOR) + urlWithoutProtocol;
        }
        return ideaUrl;
    }

    @Nullable
    public static VirtualFile findRelativeFile(@NotNull String uri, @Nullable VirtualFile base) {
        if (base != null && !base.isValid()) {
            LOG.error("Invalid file name: " + base.getName() + ", url: " + uri);
        }
        if ((uri = uri.replace('\\', '/')).startsWith("file:///")) {
            uri = uri.substring("file:///".length());
            if (!SystemInfo.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else if (uri.startsWith("file:/")) {
            uri = uri.substring("file:/".length());
            if (!SystemInfo.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
        } else {
            uri = StringUtil.trimStart((String)uri, (String)"file:");
        }
        VirtualFile file = null;
        if (uri.startsWith("jar:file:/")) {
            uri = uri.substring("jar:file:/".length());
            if (!SystemInfo.isWindows) {
                uri = VFS_SEPARATOR + uri;
            }
            file = VirtualFileManager.getInstance().findFileByUrl("jar://" + uri);
        } else if (!SystemInfo.isWindows && StringUtil.startsWithChar((CharSequence)uri, (char)'/') || SystemInfo.isWindows && uri.length() >= 2 && Character.isLetter(uri.charAt(0)) && uri.charAt(1) == ':') {
            file = StandardFileSystems.local().findFileByPath(uri);
        }
        if (file == null && uri.contains("!/") && (file = StandardFileSystems.jar().findFileByPath(uri)) == null && base == null) {
            file = VirtualFileManager.getInstance().findFileByUrl(uri);
        }
        if (file == null) {
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            if (!base.isDirectory()) {
                base = base.getParent();
            }
            if (base == null) {
                return StandardFileSystems.local().findFileByPath(uri);
            }
            file = VirtualFileManager.getInstance().findFileByUrl(base.getUrl() + VFS_SEPARATOR + uri);
        }
        return file;
    }

    public static boolean processFilesRecursively(final @NotNull VirtualFile root, final @NotNull Processor<? super VirtualFile> processor) {
        final Ref result = Ref.create((Object)true);
        VfsUtilCore.visitChildrenRecursively(root, new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            @Override
            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (!processor.process((Object)file)) {
                    result.set((Object)Boolean.FALSE);
                    return 2.skipTo(root);
                }
                return CONTINUE;
            }
        });
        return (Boolean)result.get();
    }

    @Nullable
    public static VirtualFile getCommonAncestor(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        VirtualFile parent1;
        if (!file1.getFileSystem().equals(file2.getFileSystem())) {
            return null;
        }
        if (file1.equals(file2)) {
            return file1;
        }
        int depth1 = VfsUtilCore.depth(file1);
        int depth2 = VfsUtilCore.depth(file2);
        VirtualFile parent2 = file2;
        for (parent1 = file1; depth1 > depth2 && parent1 != null; parent1 = parent1.getParent(), --depth1) {
        }
        while (depth2 > depth1 && parent2 != null) {
            parent2 = parent2.getParent();
            --depth2;
        }
        while (parent1 != null && parent2 != null && !parent1.equals(parent2)) {
            parent1 = parent1.getParent();
            parent2 = parent2.getParent();
        }
        return parent1;
    }

    private static int depth(VirtualFile file) {
        int depth = 0;
        while (file != null) {
            ++depth;
            file = file.getParent();
        }
        return depth;
    }

    static VirtualFile @NotNull [] getPathComponents(@NotNull VirtualFile file) {
        ArrayList<VirtualFile> componentsList = new ArrayList<VirtualFile>();
        while (file != null) {
            componentsList.add(file);
            file = file.getParent();
        }
        int size = componentsList.size();
        VirtualFile[] components = new VirtualFile[size];
        for (int i = 0; i < size; ++i) {
            components[i] = (VirtualFile)componentsList.get(size - i - 1);
        }
        return components;
    }

    public static boolean hasInvalidFiles(@NotNull Iterable<? extends VirtualFile> files) {
        for (VirtualFile virtualFile2 : files) {
            if (virtualFile2.isValid()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile findContainingDirectory(@NotNull VirtualFile file, @NotNull CharSequence name) {
        VirtualFile parent;
        VirtualFile virtualFile2 = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            if (Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)name, (boolean)SystemInfo.isFileSystemCaseSensitive)) {
                return parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    @NotNull
    public static VirtualFile getRootFile(@NotNull VirtualFile file) {
        VirtualFile parent;
        while ((parent = file.getParent()) != null) {
            file = parent;
        }
        return file;
    }

    public static class DistinctVFilesRootsCollection
    extends DistinctRootsCollection<VirtualFile> {
        public DistinctVFilesRootsCollection(@NotNull Collection<? extends VirtualFile> virtualFiles) {
            super(virtualFiles);
        }

        public DistinctVFilesRootsCollection(VirtualFile @NotNull [] collection) {
            super((Object[])collection);
        }

        protected boolean isAncestor(@NotNull VirtualFile ancestor, @NotNull VirtualFile virtualFile2) {
            return VfsUtilCore.isAncestor(ancestor, virtualFile2, false);
        }
    }
}

