/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.LocalFileOperationsHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.SystemIndependent;

public abstract class LocalFileSystem
extends NewVirtualFileSystem {
    public static final String PROTOCOL = "file";
    public static final String PROTOCOL_PREFIX = "file://";

    public static LocalFileSystem getInstance() {
        return LocalFileSystemHolder.ourInstance;
    }

    @Nullable
    public abstract VirtualFile findFileByIoFile(@NotNull File var1);

    @Nullable
    public final VirtualFile findFileByNioFile(@NotNull Path file) {
        return this.findFileByPath(file.toString().replace(File.separatorChar, '/'));
    }

    @Nullable
    public abstract VirtualFile refreshAndFindFileByIoFile(@NotNull File var1);

    @Nullable
    public final VirtualFile refreshAndFindFileByNioFile(@NotNull Path file) {
        return this.refreshAndFindFileByPath(file.toString().replace(File.separatorChar, '/'));
    }

    public void refreshIoFiles(@NotNull Iterable<? extends File> files) {
        this.refreshIoFiles(files, false, false, null);
    }

    public final void refreshNioFiles(@NotNull Iterable<Path> files) {
        this.refreshIoFiles(ContainerUtil.map(files, Path::toFile), false, false, null);
    }

    public abstract void refreshIoFiles(@NotNull Iterable<? extends File> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    public void refreshFiles(@NotNull Iterable<? extends VirtualFile> files) {
        this.refreshFiles(files, false, false, null);
    }

    public abstract void refreshFiles(@NotNull Iterable<? extends VirtualFile> var1, boolean var2, boolean var3, @Nullable Runnable var4);

    @Nullable
    public WatchRequest addRootToWatch(@NotNull String rootPath, boolean watchRecursively) {
        Set<WatchRequest> result = this.addRootsToWatch(Collections.singleton(rootPath), watchRecursively);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public Set<WatchRequest> addRootsToWatch(@NotNull Collection<String> rootPaths, boolean watchRecursively) {
        if (rootPaths.isEmpty()) {
            return Collections.emptySet();
        }
        if (watchRecursively) {
            return this.replaceWatchedRoots(Collections.emptySet(), rootPaths, null);
        }
        return this.replaceWatchedRoots(Collections.emptySet(), null, rootPaths);
    }

    public void removeWatchedRoot(@NotNull WatchRequest watchRequest) {
        this.removeWatchedRoots(Collections.singleton(watchRequest));
    }

    public void removeWatchedRoots(@NotNull Collection<WatchRequest> watchRequests) {
        if (!watchRequests.isEmpty()) {
            this.replaceWatchedRoots(watchRequests, null, null);
        }
    }

    @Nullable
    public WatchRequest replaceWatchedRoot(@Nullable WatchRequest watchRequest, @NotNull String rootPath, boolean watchRecursively) {
        Set<WatchRequest> requests = watchRequest != null ? Collections.singleton(watchRequest) : Collections.emptySet();
        Set<String> roots = Collections.singleton(rootPath);
        Set<WatchRequest> result = watchRecursively ? this.replaceWatchedRoots(requests, roots, null) : this.replaceWatchedRoots(requests, null, roots);
        return result.size() == 1 ? result.iterator().next() : null;
    }

    @NotNull
    public abstract Set<WatchRequest> replaceWatchedRoots(@NotNull Collection<WatchRequest> var1, @Nullable Collection<String> var2, @Nullable Collection<String> var3);

    public abstract void registerAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public abstract void unregisterAuxiliaryFileOperationsHandler(@NotNull LocalFileOperationsHandler var1);

    public static interface WatchRequest {
        @NotNull
        public @SystemIndependent String getRootPath();

        public boolean isToWatchRecursively();
    }

    private static class LocalFileSystemHolder {
        private static final LocalFileSystem ourInstance = (LocalFileSystem)VirtualFileManager.getInstance().getFileSystem("file");

        private LocalFileSystemHolder() {
        }
    }
}

