/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.FilePathsHelper;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.CurrentRevisionProvider;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingRegistry;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.lang.ref.Reference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentRevisionCache {
    private final Object myLock;
    private final SLRUMap<Key, SoftReference<byte[]>> myCache;
    private final SLRUMap<CurrentKey, VcsRevisionNumber> myCurrentRevisionsCache;
    private final Map<Key, byte[]> myConstantCache = new HashMap<Key, byte[]>();
    private long myCounter = 0L;

    public ContentRevisionCache() {
        this.myLock = new Object();
        this.myCache = new SLRUMap(100, 50);
        this.myCurrentRevisionsCache = new SLRUMap(200, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, byte @Nullable [] bytes) {
        if (bytes == null) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myCache.put((Object)new Key(path2, number, vcsKey, type), (Object)new SoftReference((Object)bytes));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllCurrent() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
        }
    }

    public void clearScope(List<? extends VcsDirtyScope> scopes) {
        ApplicationManager.getApplication().runReadAction(() -> {
            Object object = this.myLock;
            synchronized (object) {
                ++this.myCounter;
                for (VcsDirtyScope scope : scopes) {
                    HashSet toRemove = new HashSet();
                    this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                        if (scope.belongsTo(currentKey.getPath())) {
                            toRemove.add(currentKey);
                        }
                    });
                    for (CurrentKey key : toRemove) {
                        this.myCurrentRevisionsCache.remove((Object)key);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCurrent(Set<String> paths) {
        HashSet<String> converted = new HashSet<String>();
        for (String path2 : paths) {
            converted.add(FilePathsHelper.convertPath(path2));
        }
        Object object = this.myLock;
        synchronized (object) {
            HashSet toRemove = new HashSet();
            this.myCurrentRevisionsCache.iterateKeys(currentKey -> {
                if (converted.contains(FilePathsHelper.convertPath(currentKey.getPath().getPath()))) {
                    toRemove.add(currentKey);
                }
            });
            for (CurrentKey key : toRemove) {
                this.myCurrentRevisionsCache.remove((Object)key);
            }
        }
    }

    @Nullable
    @Contract(value="!null, _, _ -> !null")
    public static String getAsString(byte @Nullable [] bytes, @NotNull FilePath file, @Nullable Charset charset) {
        if (bytes == null) {
            return null;
        }
        if (charset == null) {
            return ContentRevisionCache.bytesToString(file, bytes);
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)charset);
    }

    @NotNull
    public static String getOrLoadAsString(@NotNull Project project, @NotNull FilePath file, VcsRevisionNumber number, @NotNull VcsKey key, @NotNull UniqueType type, @NotNull Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader, @Nullable Charset charset) throws VcsException, IOException {
        byte[] bytes = ContentRevisionCache.getOrLoadAsBytes(project, file, number, key, type, loader);
        return ContentRevisionCache.getAsString(bytes, file, charset);
    }

    @NotNull
    public static String getOrLoadAsString(Project project, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, Throwable2Computable<byte[], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        return ContentRevisionCache.getOrLoadAsString(project, path2, number, vcsKey, type, loader, null);
    }

    @NotNull
    private static String bytesToString(FilePath path2, byte @NotNull [] bytes) {
        Charset charset = null;
        if (path2.getVirtualFile() != null) {
            charset = path2.getVirtualFile().getCharset();
        }
        if (charset != null) {
            int bomLength = CharsetToolkit.getBOMLength((byte[])bytes, (Charset)charset);
            CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
            return charBuffer.toString();
        }
        return CharsetToolkit.bytesToString((byte[])bytes, (Charset)EncodingRegistry.getInstance().getDefaultCharset());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte @Nullable [] getBytes(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type) {
        Object object = this.myLock;
        synchronized (object) {
            SoftReference reference = (SoftReference)this.myCache.get((Object)new Key(path2, number, vcsKey, type));
            return (byte[])SoftReference.dereference((Reference)reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean putCurrent(FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, long counter) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myCounter != counter) {
                return false;
            }
            ++this.myCounter;
            this.myCurrentRevisionsCache.put((Object)new CurrentKey(path2, vcsKey), (Object)number);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<VcsRevisionNumber, Long> getCurrent(FilePath path2, VcsKey vcsKey) {
        Object object = this.myLock;
        synchronized (object) {
            return new Pair(this.myCurrentRevisionsCache.get((Object)new CurrentKey(path2, vcsKey)), (Object)this.myCounter);
        }
    }

    public static byte @NotNull [] getOrLoadAsBytes(Project project, FilePath path2, VcsRevisionNumber number, @NotNull VcsKey vcsKey, @NotNull UniqueType type, Throwable2Computable<byte @NotNull [], ? extends VcsException, ? extends IOException> loader) throws VcsException, IOException {
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache();
        byte[] bytes = cache.getBytes(path2, number, vcsKey, type);
        if (bytes != null) {
            return bytes;
        }
        bytes = cache.getFromConstantCache(path2, number, vcsKey, type);
        if (bytes != null) {
            return bytes;
        }
        ContentRevisionCache.checkLocalFileSize(path2);
        bytes = (byte[])loader.compute();
        cache.put(path2, number, vcsKey, type, bytes);
        return bytes;
    }

    private static void checkLocalFileSize(FilePath path2) throws VcsException {
        File ioFile = path2.getIOFile();
        if (ioFile.exists()) {
            ContentRevisionCache.checkContentsSize(ioFile.getPath(), ioFile.length());
        }
    }

    public static void checkContentsSize(String path2, long size) throws VcsException {
        if (size > (long)VcsUtil.getMaxVcsLoadedFileSize()) {
            throw new VcsException("Can not show contents of \n'" + path2 + "'.\nFile size is bigger than " + StringUtil.formatFileSize((long)VcsUtil.getMaxVcsLoadedFileSize()) + ".\n\nYou can relax this restriction by increasing " + "idea.max.vcs.loaded.size.kb" + " property in idea.properties file.");
        }
    }

    private static VcsRevisionNumber putIntoCurrentCache(ContentRevisionCache cache, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException {
        Pair<VcsRevisionNumber, Long> currentRevision;
        VcsRevisionNumber loadedRevisionNumber;
        do {
            if (!(loadedRevisionNumber = loader.getCurrentRevision()).equals((currentRevision = cache.getCurrent(path2, vcsKey)).getFirst())) continue;
            return loadedRevisionNumber;
        } while (!cache.putCurrent(path2, loadedRevisionNumber, vcsKey, (Long)currentRevision.getSecond()));
        return loadedRevisionNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putIntoConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, byte[] content) {
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            this.myConstantCache.put(new Key(path2, revisionNumber, vcsKey, UniqueType.REPOSITORY_CONTENT), content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getFromConstantCache(@NotNull FilePath path2, @NotNull VcsRevisionNumber revisionNumber, @NotNull VcsKey vcsKey, @NotNull UniqueType type) {
        Map<Key, byte[]> map = this.myConstantCache;
        synchronized (map) {
            return this.myConstantCache.get(new Key(path2, revisionNumber, vcsKey, type));
        }
    }

    public void clearConstantCache() {
        this.myConstantCache.clear();
    }

    public static Pair<VcsRevisionNumber, byte[]> getOrLoadCurrentAsBytes(Project project, FilePath path2, @NotNull VcsKey vcsKey, CurrentRevisionProvider loader) throws VcsException, IOException {
        VcsRevisionNumber currentRevision;
        Pair<VcsRevisionNumber, byte[]> loaded;
        ContentRevisionCache cache = ProjectLevelVcsManager.getInstance(project).getContentRevisionCache();
        do {
            byte[] cachedCurrent;
            if ((cachedCurrent = cache.getBytes(path2, currentRevision = ContentRevisionCache.putIntoCurrentCache(cache, path2, vcsKey, loader), vcsKey, UniqueType.REPOSITORY_CONTENT)) != null) {
                return Pair.create((Object)currentRevision, (Object)cachedCurrent);
            }
            ContentRevisionCache.checkLocalFileSize(path2);
        } while (!((VcsRevisionNumber)(loaded = loader.get()).getFirst()).equals(currentRevision));
        cache.put(path2, currentRevision, vcsKey, UniqueType.REPOSITORY_CONTENT, (byte[])loaded.getSecond());
        return loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.myLock;
        synchronized (object) {
            ++this.myCounter;
            this.myCurrentRevisionsCache.clear();
            this.myCache.clear();
            this.myConstantCache.clear();
        }
    }

    public static enum UniqueType {
        REPOSITORY_CONTENT,
        REMOTE_CONTENT;

    }

    private static class Key
    extends CurrentKey {
        private final VcsRevisionNumber myNumber;
        protected final UniqueType myType;

        private Key(FilePath path2, VcsRevisionNumber number, VcsKey vcsKey, UniqueType type) {
            super(path2, vcsKey);
            this.myNumber = number;
            this.myType = type;
        }

        public VcsRevisionNumber getNumber() {
            return this.myNumber;
        }

        public UniqueType getType() {
            return this.myType;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Key key = (Key)o;
            if (this.myNumber != null ? !this.myNumber.equals(key.myNumber) : key.myNumber != null) {
                return false;
            }
            if (!this.myPath.equals(key.myPath)) {
                return false;
            }
            if (this.myType != key.myType) {
                return false;
            }
            return this.myVcsKey.equals(key.myVcsKey);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myPath.hashCode();
            result = 31 * result + (this.myNumber != null ? this.myNumber.hashCode() : 0);
            result = 31 * result + this.myVcsKey.hashCode();
            result = 31 * result + this.myType.hashCode();
            return result;
        }
    }

    private static class CurrentKey {
        protected final FilePath myPath;
        protected final VcsKey myVcsKey;

        private CurrentKey(FilePath path2, VcsKey vcsKey) {
            this.myPath = path2;
            this.myVcsKey = vcsKey;
        }

        public FilePath getPath() {
            return this.myPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CurrentKey that = (CurrentKey)o;
            if (this.myPath != null ? !this.myPath.equals(that.myPath) : that.myPath != null) {
                return false;
            }
            return !(this.myVcsKey != null ? !this.myVcsKey.equals(that.myVcsKey) : that.myVcsKey != null);
        }

        public int hashCode() {
            int result = this.myPath != null ? this.myPath.hashCode() : 0;
            result = 31 * result + (this.myVcsKey != null ? this.myVcsKey.hashCode() : 0);
            return result;
        }
    }
}

