/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.diff;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DiffProvider {
    @Nullable
    public VcsRevisionNumber getCurrentRevision(VirtualFile var1);

    @Nullable
    public ItemLatestState getLastRevision(VirtualFile var1);

    @Nullable
    public ItemLatestState getLastRevision(FilePath var1);

    @Nullable
    public ContentRevision createFileContent(VcsRevisionNumber var1, VirtualFile var2);

    @Nullable
    public VcsRevisionNumber getLatestCommittedRevision(VirtualFile var1);

    @Nullable
    default public ContentRevision createCurrentFileContent(VirtualFile file) {
        VcsRevisionNumber revisionNumber = this.getCurrentRevision(file);
        if (revisionNumber == null) {
            return null;
        }
        return this.createFileContent(revisionNumber, file);
    }

    default public void preloadBaseRevisions(@NotNull VirtualFile root, @NotNull Collection<Change> changes) {
    }

    default public boolean canCompareWithWorkingDir() {
        return false;
    }

    @Nullable
    default public Collection<Change> compareWithWorkingDir(@NotNull VirtualFile fileOrDir, @NotNull VcsRevisionNumber revNum) throws VcsException {
        return null;
    }
}

