/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CachingCommittedChangesProvider<T extends CommittedChangeList, U extends ChangeBrowserSettings>
extends CommittedChangesProvider<T, U> {
    public int getFormatVersion();

    public void writeChangeList(@NotNull DataOutput var1, @NotNull T var2) throws IOException;

    @NotNull
    public T readChangeList(@NotNull RepositoryLocation var1, @NotNull DataInput var2) throws IOException;

    default public boolean isMaxCountSupported() {
        return true;
    }

    @Nullable
    default public Collection<FilePath> getIncomingFiles(@NotNull RepositoryLocation location) throws VcsException {
        return null;
    }

    default public boolean refreshCacheByNumber() {
        return true;
    }

    @Nullable
    @Nls
    public String getChangelistTitle();

    default public boolean isChangeLocallyAvailable(@NotNull FilePath filePath2, @Nullable VcsRevisionNumber localRevision, @NotNull VcsRevisionNumber changeRevision, @NotNull T changeList) {
        return localRevision != null && localRevision.compareTo(changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted();
}

