/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.messages;

import com.intellij.openapi.ui.messages.MessageDialog;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.PairFunction;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TwoStepConfirmationDialog
extends MessageDialog {
    private JCheckBox myCheckBox;
    private final String myCheckboxText;
    private final boolean myChecked;
    private final PairFunction<? super Integer, ? super JCheckBox, Integer> myExitFunc;

    public TwoStepConfirmationDialog(@NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, @NlsContexts.Checkbox String checkboxText, boolean checked, int defaultOptionIndexed, int focusedOptionIndex, Icon icon, @Nullable PairFunction<? super Integer, ? super JCheckBox, Integer> exitFunc) {
        this.myCheckboxText = checkboxText;
        this.myChecked = checked;
        this.myExitFunc = exitFunc;
        this._init(title, message, options, defaultOptionIndexed, focusedOptionIndex, icon, null);
    }

    @Override
    protected JComponent createNorthPanel() {
        JPanel panel2 = this.createIconPanel();
        JPanel messagePanel = this.createMessagePanel();
        messagePanel.add((Component)this.createCheckComponent(), "South");
        panel2.add((Component)messagePanel, "Center");
        return panel2;
    }

    @NotNull
    protected JComponent createCheckComponent() {
        this.myCheckBox = new JCheckBox(this.myCheckboxText);
        this.myCheckBox.setSelected(this.myChecked);
        return this.myCheckBox;
    }

    @Override
    public int getExitCode() {
        int exitCode = super.getExitCode();
        if (this.myExitFunc != null) {
            return (Integer)this.myExitFunc.fun((Object)exitCode, (Object)this.myCheckBox);
        }
        boolean checkBoxSelected = this.myCheckBox != null && this.myCheckBox.isSelected();
        boolean okExitCode = exitCode == 0;
        return checkBoxSelected && okExitCode ? 0 : 1;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myDefaultOptionIndex == -1 ? this.myCheckBox : super.getPreferredFocusedComponent();
    }

    @Override
    protected JComponent createCenterPanel() {
        return null;
    }
}

