/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PanelWithActionsAndCloseButton
extends JPanel
implements DataProvider,
Disposable {
    protected final ContentManager myContentManager;
    private final String myHelpId;
    private final boolean myVerticalToolbar;
    private boolean myCloseEnabled;
    private final DefaultActionGroup myToolbarGroup = new DefaultActionGroup();

    public PanelWithActionsAndCloseButton(ContentManager contentManager, @NonNls String helpId) {
        this(contentManager, helpId, true);
    }

    public PanelWithActionsAndCloseButton(ContentManager contentManager, @NonNls String helpId, boolean verticalToolbar) {
        super(new BorderLayout());
        this.myContentManager = contentManager;
        this.myHelpId = helpId;
        this.myVerticalToolbar = verticalToolbar;
        this.myCloseEnabled = true;
        if (this.myContentManager != null) {
            this.myContentManager.addContentManagerListener(new ContentManagerListener(){

                @Override
                public void contentRemoved(@NotNull ContentManagerEvent event) {
                    if (event.getContent().getComponent() == PanelWithActionsAndCloseButton.this) {
                        Disposer.dispose((Disposable)PanelWithActionsAndCloseButton.this);
                        PanelWithActionsAndCloseButton.this.myContentManager.removeContentManagerListener(this);
                    }
                }
            });
        }
    }

    public String getHelpId() {
        return this.myHelpId;
    }

    protected void disableClose() {
        this.myCloseEnabled = false;
    }

    protected void init() {
        this.addActionsTo(this.myToolbarGroup);
        this.myToolbarGroup.add(new MyCloseAction());
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("FileHistoryViewToolbar", this.myToolbarGroup, !this.myVerticalToolbar);
        JComponent centerPanel = this.createCenterPanel();
        toolbar.setTargetComponent(centerPanel);
        for (AnAction action : this.myToolbarGroup.getChildren(null)) {
            action.registerCustomShortcutSet(action.getShortcutSet(), centerPanel);
        }
        this.add((Component)centerPanel, "Center");
        if (this.myVerticalToolbar) {
            this.add((Component)toolbar.getComponent(), "West");
        } else {
            this.add((Component)toolbar.getComponent(), "North");
        }
    }

    @Override
    public Object getData(@NotNull String dataId) {
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return this.myHelpId;
        }
        return null;
    }

    protected abstract JComponent createCenterPanel();

    protected void addActionsTo(DefaultActionGroup group) {
    }

    private class MyCloseAction
    extends CloseTabToolbarAction {
        private MyCloseAction() {
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            super.update(e);
            e.getPresentation().setVisible(PanelWithActionsAndCloseButton.this.myCloseEnabled);
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            Content content;
            if (PanelWithActionsAndCloseButton.this.myContentManager != null && (content = PanelWithActionsAndCloseButton.this.myContentManager.getContent(PanelWithActionsAndCloseButton.this)) != null) {
                ContentsUtil.closeContentTab(PanelWithActionsAndCloseButton.this.myContentManager, content);
            }
        }
    }
}

