/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ui.SimpleColoredComponent;
import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ComboBoxWithWidePopup<E>
extends JComboBox<E> {
    private int myMinLength = 20;

    public ComboBoxWithWidePopup() {
    }

    public ComboBoxWithWidePopup(@NotNull ComboBoxModel<E> model) {
        super(model);
    }

    public ComboBoxWithWidePopup(E @NotNull [] items) {
        super(items);
    }

    @Override
    public void setRenderer(ListCellRenderer<? super E> renderer) {
        if (renderer instanceof SimpleColoredComponent) {
            SimpleColoredComponent scc = (SimpleColoredComponent)((Object)renderer);
            scc.getIpad().bottom = 0;
            scc.getIpad().top = 0;
        }
        super.setRenderer(new AdjustingListCellRenderer(renderer));
    }

    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    protected int getMinLength() {
        return this.myMinLength;
    }

    public int getMinimumPopupWidth() {
        return super.getPreferredSize().width;
    }

    private class AdjustingListCellRenderer
    implements ListCellRenderer<E> {
        private final ListCellRenderer<? super E> delegate;

        AdjustingListCellRenderer(ListCellRenderer<? super E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends E> list, E value, int index, boolean isSelected, boolean cellHasFocus) {
            if (index == -1 && value instanceof String && !ComboBoxWithWidePopup.this.isValid()) {
                int minLength = ComboBoxWithWidePopup.this.getMinLength();
                String stringValue = (String)value;
                if (ComboBoxWithWidePopup.this.getSize().width == 0 && stringValue.length() > minLength) {
                    String e = stringValue.substring(0, minLength);
                    value = e;
                }
            }
            return this.delegate.getListCellRendererComponent(list, (Object)value, index, isSelected, cellHasFocus);
        }
    }
}

