/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(@NotNull Library library, @NotNull String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(library.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile @NotNull [] files, @NotNull String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(Arrays.asList(files), fqn);
    }

    public static boolean isClassAvailableInLibrary(@NotNull List<? extends VirtualFile> files, @NotNull String fqn) {
        for (VirtualFile virtualFile2 : files) {
            if (!LibraryUtil.findInFile(virtualFile2, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(@NotNull String fqn, @Nullable Project project) {
        LibraryTable projectTable;
        Library library;
        if (project != null && (library = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project), fqn)) != null) {
            return library;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table, fqn);
    }

    private static boolean findInFile(@NotNull VirtualFile file, @NotNull StringTokenizer tokenizer) {
        VirtualFile child;
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        StringBuilder name = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name.append(".class");
        }
        return (child = file.findChild(name.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(@NotNull LibraryTable table, @NotNull String fqn) {
        for (Library library : table.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library, fqn)) continue;
            return library;
        }
        return null;
    }

    @NotNull
    public static Library createLibrary(@NotNull LibraryTable libraryTable, @NonNls @NotNull String baseName) {
        String name = baseName;
        int count = 2;
        while (libraryTable.getLibraryByName(name) != null) {
            name = baseName + " (" + count++ + ")";
        }
        return libraryTable.createLibrary(name);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project) {
        return LibraryUtil.getLibraryRoots(project, true, true);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(@NotNull Project project, boolean includeSourceFiles, boolean includeJdk) {
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile @NotNull [] getLibraryRoots(Module @NotNull [] modules, boolean includeSourceFiles, boolean includeJdk) {
        HashSet roots = new HashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module);
            for (OrderEntry entry : orderEntries = moduleRootManager.getOrderEntries()) {
                Object[] files;
                if (entry instanceof LibraryOrderEntry) {
                    Library library = ((LibraryOrderEntry)entry).getLibrary();
                    if (library == null) continue;
                    Object[] objectArray = files = includeSourceFiles ? library.getFiles(OrderRootType.SOURCES) : null;
                    if (files == null || files.length == 0) {
                        files = library.getFiles(OrderRootType.CLASSES);
                    }
                    ContainerUtil.addAll(roots, (Object[])files);
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                JdkOrderEntry jdkEntry = (JdkOrderEntry)entry;
                Object[] objectArray = files = includeSourceFiles ? jdkEntry.getRootFiles(OrderRootType.SOURCES) : null;
                if (files == null || files.length == 0) {
                    files = jdkEntry.getRootFiles(OrderRootType.CLASSES);
                }
                ContainerUtil.addAll(roots, (Object[])files);
            }
        }
        return VfsUtilCore.toVirtualFileArray(roots);
    }

    @Nullable
    public static Library findLibrary(@NotNull Module module, @NotNull String name) {
        Ref result = Ref.create(null);
        OrderEnumerator.orderEntries(module).forEachLibrary((Processor<? super Library>)((Processor)library -> {
            if (name.equals(library.getName())) {
                result.set(library);
                return false;
            }
            return true;
        }));
        return (Library)result.get();
    }

    @Nullable
    public static OrderEntry findLibraryEntry(@NotNull VirtualFile file, @NotNull Project project) {
        List<OrderEntry> entries = ProjectRootManager.getInstance(project).getFileIndex().getOrderEntriesForFile(file);
        for (OrderEntry entry : entries) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public static String getPresentableName(@NotNull Library library) {
        String name = library.getName();
        if (name != null) {
            return name;
        }
        if (library instanceof LibraryEx && ((LibraryEx)library).isDisposed()) {
            return "Disposed Library";
        }
        String[] urls = library.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            return PathUtil.getFileName(VfsUtilCore.urlToPath(urls[0]));
        }
        return "Empty Library";
    }
}

