/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.roots.libraries.TemporaryLibraryKind;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class LibraryKind {
    private final String myKindId;
    private static final Map<String, LibraryKind> ourAllKinds = new HashMap<String, LibraryKind>();

    public LibraryKind(@NotNull @NonNls String kindId) {
        this.myKindId = kindId;
        LibraryKind kind = ourAllKinds.get(kindId);
        if (kind != null && !(kind instanceof TemporaryLibraryKind)) {
            throw new IllegalArgumentException("Kind " + kindId + " is not unique");
        }
        ourAllKinds.put(kindId, this);
    }

    public final String getKindId() {
        return this.myKindId;
    }

    public String toString() {
        return "LibraryKind:" + this.myKindId;
    }

    public static LibraryKind create(@NotNull @NonNls String kindId) {
        return new LibraryKind(kindId);
    }

    public static LibraryKind findById(String kindId) {
        return ourAllKinds.get(kindId);
    }

    @ApiStatus.Internal
    public static void unregisterKind(@NotNull LibraryKind kind) {
        ourAllKinds.remove(kind.getKindId());
    }

    @ApiStatus.Internal
    public static void registerKind(@NotNull LibraryKind kind) {
        ourAllKinds.put(kind.getKindId(), kind);
    }
}

