/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Platform;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.target.ContributedConfigurationsList;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.java.JavaLanguageRuntimeConfiguration;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JdkCommandLineSetup;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.text.StringKt;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.jar.Manifest;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u0000 R2\u00020\u0001:\u0003PQRB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0002J\u0018\u0010)\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020&H\u0002J\u0018\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\u0017H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020\"2\u0006\u0010(\u001a\u00020&H\u0002J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u0017002\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002J\"\u00103\u001a\b\u0012\u0004\u0012\u00020\u0017002\u0012\u00104\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170005H\u0002J$\u00106\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001700072\u0006\u0010#\u001a\u00020$2\u0006\u00101\u001a\u000202H\u0002J\u001c\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001700072\u0006\u0010#\u001a\u00020$H\u0002J\u001b\u00109\u001a\u00020\u00172\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00170;H\u0002\u00a2\u0006\u0002\u0010<J\u001e\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001700H\u0002J0\u0010A\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020&2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020FH\u0002J4\u0010G\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020&2\n\u0010H\u001a\u0006\u0012\u0002\b\u00030I2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020CH\u0002J<\u0010J\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010(\u001a\u00020&2\n\u0010H\u001a\u0006\u0012\u0002\b\u00030I2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020FH\u0002J\u0010\u0010K\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010L\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010M\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u000e\u0010N\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0010\u0010O\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R \u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR \u0010\u000e\u001a\u00070\b\u00a2\u0006\u0002\b\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup;", "", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "target", "Lcom/intellij/execution/target/TargetEnvironmentConfiguration;", "(Lcom/intellij/execution/target/TargetEnvironmentRequest;Lcom/intellij/execution/target/TargetEnvironmentConfiguration;)V", "agentVolume", "Lcom/intellij/execution/target/TargetEnvironmentRequest$Volume;", "Lorg/jetbrains/annotations/NotNull;", "getAgentVolume", "()Lcom/intellij/execution/target/TargetEnvironmentRequest$Volume;", "agentVolume$delegate", "Lkotlin/Lazy;", "classPathVolume", "getClassPathVolume", "classPathVolume$delegate", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLine", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "commandLineContent", "", "", "getCommandLineContent", "()Ljava/util/Map;", "commandLineContent$delegate", "languageRuntime", "Lcom/intellij/execution/target/java/JavaLanguageRuntimeConfiguration;", "platform", "Lcom/intellij/execution/Platform;", "getPlatform", "()Lcom/intellij/execution/Platform;", "appendEncoding", "", "javaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "parametersList", "Lcom/intellij/execution/configurations/ParametersList;", "appendModulePath", "vmParameters", "appendParamsEncodingClasspath", "appendVmAgentParameter", "vmParameter", "prefix", "appendVmParameter", "appendVmParameters", "composeClassPathValues", "Lcom/intellij/execution/target/value/TargetValue;", "classPath", "Lcom/intellij/util/PathsList;", "composePathsList", "targetPaths", "", "getClassPathValues", "", "getMainClassParams", "joinPath", "segments", "", "([Ljava/lang/String;)Ljava/lang/String;", "rememberFileContentAfterUpload", "localFile", "Ljava/io/File;", "fileUpload", "setArgFileParams", "dynamicVMOptions", "", "dynamicParameters", "cs", "Ljava/nio/charset/Charset;", "setClasspathJarParams", "commandLineWrapper", "Ljava/lang/Class;", "setCommandLineWrapperParams", "setupClasspathAndParameters", "setupCommandLine", "setupEnvironment", "setupJavaExePath", "setupWorkingDirectory", "ArgFile", "ClasspathJar", "Companion", "intellij.platform.lang"})
public final class JdkCommandLineSetup {
    @NotNull
    private final TargetedCommandLineBuilder commandLine;
    @NotNull
    private final Platform platform;
    private final JavaLanguageRuntimeConfiguration languageRuntime;
    private final Lazy classPathVolume$delegate;
    private final Lazy agentVolume$delegate;
    private final Lazy commandLineContent$delegate;
    private final TargetEnvironmentRequest request;
    private final TargetEnvironmentConfiguration target;
    private static final String JAVAAGENT = "-javaagent";
    private static final Lazy LOG$delegate;
    public static final Companion Companion;

    @NotNull
    public final TargetedCommandLineBuilder getCommandLine() {
        return this.commandLine;
    }

    @NotNull
    public final Platform getPlatform() {
        return this.platform;
    }

    private final TargetEnvironmentRequest.Volume getClassPathVolume() {
        Lazy lazy = this.classPathVolume$delegate;
        JdkCommandLineSetup jdkCommandLineSetup = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TargetEnvironmentRequest.Volume)lazy.getValue();
    }

    private final TargetEnvironmentRequest.Volume getAgentVolume() {
        Lazy lazy = this.agentVolume$delegate;
        JdkCommandLineSetup jdkCommandLineSetup = this;
        Object var3_3 = null;
        boolean bl = false;
        return (TargetEnvironmentRequest.Volume)lazy.getValue();
    }

    private final Map<String, String> getCommandLineContent() {
        Lazy lazy = this.commandLineContent$delegate;
        JdkCommandLineSetup jdkCommandLineSetup = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Map)lazy.getValue();
    }

    public final void setupCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        this.setupWorkingDirectory(javaParameters);
        this.setupEnvironment(javaParameters);
        this.setupClasspathAndParameters(javaParameters);
    }

    public final void setupJavaExePath(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        if (this.request instanceof LocalTargetEnvironmentRequest || this.target == null) {
            Sdk sdk = javaParameters.getJdk();
            if (sdk == null) {
                throw (Throwable)((Object)new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0])));
            }
            Sdk jdk = sdk;
            SdkTypeId type = jdk.getSdkType();
            if (!(type instanceof JavaSdkType)) {
                throw (Throwable)((Object)new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0])));
            }
            String string = ((JavaSdkType)((Object)type)).getVMExecutablePath(jdk);
            if (string == null) {
                throw (Throwable)((Object)new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0])));
            }
            String exePath = string;
            this.commandLine.setExePath(exePath);
        } else {
            if (this.languageRuntime == null) {
                throw (Throwable)((Object)new CantRunException("Cannot find Java configuration in " + this.target.getDisplayName() + " target"));
            }
            String java = this.platform == Platform.WINDOWS ? "java.exe" : "java";
            this.commandLine.setExePath(this.joinPath(new String[]{this.languageRuntime.getHomePath(), "bin", java}));
        }
    }

    private final void setupWorkingDirectory(SimpleJavaParameters javaParameters) {
        String workingDirectory = javaParameters.getWorkingDirectory();
        if (workingDirectory != null) {
            Object object = this.languageRuntime;
            String remoteAppFolder = object != null && (object = ((JavaLanguageRuntimeConfiguration)object).getApplicationFolder()) != null ? StringKt.nullize$default((String)object, false, 1, null) : null;
            TargetEnvironmentRequest.Volume volume = this.request.createUploadRoot(remoteAppFolder, false);
            this.commandLine.setWorkingDirectory(volume.createUpload(workingDirectory));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupEnvironment(SimpleJavaParameters javaParameters) throws CantRunException {
        Map<String, String> $this$forEach$iv = javaParameters.getEnv();
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> $dstr$key$value = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry<String, String> entry = $dstr$key$value;
            boolean bl3 = false;
            String string = entry.getKey();
            entry = $dstr$key$value;
            bl3 = false;
            String value = entry.getValue();
            this.commandLine.addEnvironmentVariable((String)key, value);
        }
        if (this.request instanceof LocalTargetEnvironmentRequest) {
            GeneralCommandLine.ParentEnvironmentType type = javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE;
            ((LocalTargetEnvironmentRequest)this.request).setParentEnvironmentType(type);
        }
    }

    private final void setupClasspathAndParameters(SimpleJavaParameters javaParameters) throws CantRunException {
        ParametersList vmParameters = javaParameters.getVMParametersList();
        boolean dynamicClasspath = javaParameters.isDynamicClasspath();
        boolean dynamicVMOptions = dynamicClasspath && javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
        boolean dynamicParameters = dynamicClasspath && javaParameters.isDynamicParameters() && JdkUtil.useDynamicParameters();
        boolean dynamicMainClass = false;
        if (JdkCommandLineSetup.Companion.isUrlClassloader(vmParameters)) {
            if (!(this.request instanceof LocalTargetEnvironmentRequest)) {
                throw (Throwable)((Object)new CantRunException("Cannot run application with UrlClassPath on the remote target."));
            }
            for (String parameter : vmParameters.getParameters()) {
                if (!StringsKt.startsWith$default((String)parameter, (String)JAVAAGENT, (boolean)false, (int)2, null)) continue;
                String string = parameter;
                int n = 11;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                String jar = StringsKt.substringBefore$default((String)string3, (char)'=', null, (int)2, null);
                javaParameters.getClassPath().addFirst(jar);
            }
        }
        Class commandLineWrapperClass = JdkCommandLineSetup.Companion.commandLineWrapperClass();
        if (dynamicClasspath) {
            Charset charset = StandardCharsets.UTF_8;
            if (javaParameters.isArgFile()) {
                this.setArgFileParams(javaParameters, vmParameters, dynamicVMOptions, dynamicParameters, charset);
                dynamicMainClass = dynamicParameters;
            } else if (!JdkCommandLineSetup.Companion.isExplicitClassPath(vmParameters) && javaParameters.getJarPath() == null && commandLineWrapperClass != null) {
                if (javaParameters.isUseClasspathJar()) {
                    this.setClasspathJarParams(javaParameters, vmParameters, commandLineWrapperClass, dynamicVMOptions, dynamicParameters);
                } else if (javaParameters.isClasspathFile()) {
                    this.setCommandLineWrapperParams(javaParameters, vmParameters, commandLineWrapperClass, dynamicVMOptions, dynamicParameters, charset);
                }
            } else {
                dynamicClasspath = dynamicParameters = false;
            }
        }
        if (!dynamicClasspath) {
            this.appendParamsEncodingClasspath(javaParameters, vmParameters);
        }
        if (!dynamicMainClass) {
            for (TargetValue<String> targetValue : this.getMainClassParams(javaParameters)) {
                this.commandLine.addParameter(targetValue);
            }
        }
        if (!dynamicParameters) {
            Iterator<TargetValue<String>> iterator = javaParameters.getProgramParametersList().getList().iterator();
            while (iterator.hasNext()) {
                String string;
                String string4 = string = (String)((Object)iterator.next());
                if (string4 == null) {
                    Intrinsics.throwNpe();
                }
                this.commandLine.addParameter(string4);
            }
        }
    }

    private final void setArgFileParams(SimpleJavaParameters javaParameters, ParametersList vmParameters, boolean dynamicVMOptions, boolean dynamicParameters, Charset cs) throws CantRunException {
        try {
            PathsList modulePath;
            ArgFile argFile = new ArgFile(dynamicVMOptions, dynamicParameters, cs, this.platform);
            this.commandLine.addFileToDeleteOnTermination(argFile.getFile());
            PathsList classPath = javaParameters.getClassPath();
            if (!classPath.isEmpty() && !JdkCommandLineSetup.Companion.isExplicitClassPath(vmParameters)) {
                argFile.addPromisedParameter("-classpath", this.composeClassPathValues(javaParameters, classPath));
            }
            if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkCommandLineSetup.Companion.isExplicitModulePath(vmParameters)) {
                argFile.addPromisedParameter("-p", this.composeClassPathValues(javaParameters, modulePath));
            }
            if (dynamicParameters) {
                for (TargetValue<String> nextMainClassParam : this.getMainClassParams(javaParameters)) {
                    argFile.addPromisedParameter(nextMainClassParam);
                }
            }
            if (!dynamicVMOptions) {
                this.appendVmParameters(vmParameters);
            }
            argFile.scheduleWriteFileWhenReady(javaParameters, vmParameters);
            this.appendEncoding(javaParameters, vmParameters);
            TargetValue<String> argFileParameter = this.getClassPathVolume().createUpload(argFile.getFile().getAbsolutePath());
            this.commandLine.addParameter(TargetValue.map(argFileParameter, setArgFileParams.1.INSTANCE));
            this.rememberFileContentAfterUpload(argFile.getFile(), argFileParameter);
        }
        catch (IOException e) {
            JdkCommandLineSetup.Companion.throwUnableToCreateTempFile(e);
        }
    }

    private final void setClasspathJarParams(SimpleJavaParameters javaParameters, ParametersList vmParameters, Class<?> commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            ClasspathJar jarFile = new ClasspathJar(this, vmParameters.hasParameter("idea.do.not.escape.classpath.url"));
            this.commandLine.addFileToDeleteOnTermination(jarFile.getFile$intellij_platform_lang());
            jarFile.addToManifest("Created-By", ApplicationNamesInfo.getInstance().getFullProductName(), true);
            if (dynamicVMOptions) {
                List properties = new ArrayList();
                for (String param : vmParameters.getList()) {
                    if (JdkCommandLineSetup.Companion.isUserDefinedProperty(param)) {
                        properties.add(param);
                        continue;
                    }
                    this.appendVmParameter(param);
                }
                ClasspathJar.addToManifest$default(jarFile, "VM-Options", ParametersListUtil.join((List)properties), false, 4, null);
            } else {
                this.appendVmParameters(vmParameters);
            }
            this.appendEncoding(javaParameters, vmParameters);
            if (dynamicParameters) {
                ClasspathJar.addToManifest$default(jarFile, "Program-Parameters", ParametersListUtil.join((List)javaParameters.getProgramParametersList().getList()), false, 4, null);
            }
            TargetValue<String> targetJarFile = this.getClassPathVolume().createUpload(jarFile.getFile$intellij_platform_lang().getAbsolutePath());
            if (dynamicVMOptions || dynamicParameters) {
                this.commandLine.addParameter("-classpath");
                this.commandLine.addParameter(this.composePathsList(CollectionsKt.listOf((Object[])new TargetValue[]{this.getClassPathVolume().createUpload(PathUtil.getJarPathForClass(commandLineWrapper)), targetJarFile})));
                this.commandLine.addParameter(TargetValue.fixed(commandLineWrapper.getName()));
                this.commandLine.addParameter(targetJarFile);
            } else {
                this.commandLine.addParameter("-classpath");
                this.commandLine.addParameter(targetJarFile);
            }
            List<TargetValue<String>> classPathParameters = this.getClassPathValues(javaParameters, javaParameters.getClassPath());
            jarFile.scheduleWriteFileWhenClassPathReady(classPathParameters, targetJarFile);
        }
        catch (IOException e) {
            JdkCommandLineSetup.Companion.throwUnableToCreateTempFile(e);
        }
        this.appendModulePath(javaParameters, vmParameters);
    }

    /*
     * WARNING - void declaration
     */
    private final void setCommandLineWrapperParams(SimpleJavaParameters javaParameters, ParametersList vmParameters, Class<?> commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters, Charset cs) throws CantRunException {
        try {
            VirtualFile it;
            void $this$mapTo$iv$iv;
            int pseudoUniquePrefix = new Random().nextInt(Integer.MAX_VALUE);
            File vmParamsFile = null;
            if (dynamicVMOptions) {
                Object param2;
                List toWrite = new ArrayList();
                for (Object param2 : vmParameters.getList()) {
                    if (JdkCommandLineSetup.Companion.isUserDefinedProperty((String)param2)) {
                        toWrite.add(param2);
                        continue;
                    }
                    this.appendVmParameter((String)param2);
                }
                param2 = toWrite;
                boolean bl = false;
                if (!param2.isEmpty()) {
                    vmParamsFile = FileUtil.createTempFile((String)("idea_vm_params" + pseudoUniquePrefix), null);
                    this.commandLine.addFileToDeleteOnTermination(vmParamsFile);
                    CommandLineWrapperUtil.writeWrapperFile((File)vmParamsFile, (List)toWrite, (String)this.platform.lineSeparator, (Charset)cs);
                }
            } else {
                this.appendVmParameters(vmParameters);
            }
            this.appendEncoding(javaParameters, vmParameters);
            File appParamsFile = null;
            if (dynamicParameters) {
                appParamsFile = FileUtil.createTempFile((String)("idea_app_params" + pseudoUniquePrefix), null);
                this.commandLine.addFileToDeleteOnTermination(appParamsFile);
                CommandLineWrapperUtil.writeWrapperFile((File)appParamsFile, (List)javaParameters.getProgramParametersList().getList(), (String)this.platform.lineSeparator, (Charset)cs);
            }
            File classpathFile = FileUtil.createTempFile((String)("idea_classpath" + pseudoUniquePrefix), null);
            this.commandLine.addFileToDeleteOnTermination(classpathFile);
            List<TargetValue<String>> classPathParameters = this.getClassPathValues(javaParameters, javaParameters.getClassPath());
            Iterable $this$map$iv = classPathParameters;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                TargetValue targetValue = (TargetValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Promise promise = it.getTargetValue();
                collection.add(promise);
            }
            Promises.collectResults$default((Collection)((List)destination$iv$iv), (boolean)false, (int)1, null).onSuccess((Consumer)new Consumer<List<? extends String>>(this, classpathFile, cs){
                final /* synthetic */ JdkCommandLineSetup this$0;
                final /* synthetic */ File $classpathFile;
                final /* synthetic */ Charset $cs;

                public final void accept(List<String> pathList) {
                    CommandLineWrapperUtil.writeWrapperFile((File)this.$classpathFile, pathList, (String)this.this$0.getPlatform().lineSeparator, (Charset)this.$cs);
                }
                {
                    this.this$0 = jdkCommandLineSetup;
                    this.$classpathFile = file;
                    this.$cs = charset;
                }
            });
            Set classpath = new LinkedHashSet();
            classpath.add(this.getClassPathVolume().createUpload(PathUtil.getJarPathForClass(commandLineWrapper)));
            if (JdkCommandLineSetup.Companion.isUrlClassloader(vmParameters)) {
                if (!(this.request instanceof LocalTargetEnvironmentRequest)) {
                    throw (Throwable)((Object)new CantRunException("Cannot run application with UrlClassPath on the remote target."));
                }
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(UrlClassLoader.class)));
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(StringUtilRt.class)));
                classpath.add(TargetValue.fixed(PathUtil.getJarPathForClass(THashMap.class)));
                VirtualFile[] virtualFileArray = javaParameters.getJdk();
                if (virtualFileArray != null && (virtualFileArray = virtualFileArray.getRootProvider()) != null && (virtualFileArray = virtualFileArray.getFiles(OrderRootType.CLASSES)) != null) {
                    VirtualFile[] $this$forEach$iv = virtualFileArray;
                    boolean $i$f$forEach = false;
                    VirtualFile[] virtualFileArray2 = $this$forEach$iv;
                    int n = virtualFileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile element$iv;
                        it = element$iv = virtualFileArray2[i];
                        boolean bl = false;
                        String path2 = PathUtil.getLocalPath(it);
                        if (!StringUtil.isNotEmpty((String)path2)) continue;
                        classpath.add(TargetValue.fixed(path2));
                    }
                }
            }
            this.commandLine.addParameter("-classpath");
            this.commandLine.addParameter(this.composePathsList(classpath));
            this.commandLine.addParameter(commandLineWrapper.getName());
            TargetValue<String> classPathParameter = this.getClassPathVolume().createUpload(classpathFile.getAbsolutePath());
            this.commandLine.addParameter(classPathParameter);
            this.rememberFileContentAfterUpload(classpathFile, classPathParameter);
            if (vmParamsFile != null) {
                this.commandLine.addParameter("@vm_params");
                TargetValue<String> vmParamsParameter = this.getClassPathVolume().createUpload(vmParamsFile.getAbsolutePath());
                this.commandLine.addParameter(vmParamsParameter);
                this.rememberFileContentAfterUpload(vmParamsFile, vmParamsParameter);
            }
            if (appParamsFile != null) {
                this.commandLine.addParameter("@app_params");
                TargetValue<String> appParamsParameter = this.getClassPathVolume().createUpload(appParamsFile.getAbsolutePath());
                this.commandLine.addParameter(appParamsParameter);
                this.rememberFileContentAfterUpload(appParamsFile, appParamsParameter);
            }
        }
        catch (IOException e) {
            JdkCommandLineSetup.Companion.throwUnableToCreateTempFile(e);
        }
    }

    private final List<TargetValue<String>> getMainClassParams(SimpleJavaParameters javaParameters) throws CantRunException {
        List list;
        String mainClass = javaParameters.getMainClass();
        String moduleName = javaParameters.getModuleName();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null && moduleName != null) {
            list = CollectionsKt.listOf((Object[])new TargetValue[]{TargetValue.fixed("-m"), TargetValue.fixed(moduleName + '/' + mainClass)});
        } else if (mainClass != null) {
            list = CollectionsKt.listOf(TargetValue.fixed(mainClass));
        } else if (jarPath != null) {
            list = CollectionsKt.listOf((Object[])new TargetValue[]{TargetValue.fixed("-jar"), this.getClassPathVolume().createUpload(jarPath)});
        } else {
            throw (Throwable)((Object)new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0])));
        }
        return list;
    }

    private final void rememberFileContentAfterUpload(File localFile, TargetValue<String> fileUpload) {
        fileUpload.getTargetValue().onSuccess(new Consumer<String>(this, localFile){
            final /* synthetic */ JdkCommandLineSetup this$0;
            final /* synthetic */ File $localFile;

            public final void accept(@NotNull String resolvedTargetPath) {
                try {
                    JdkCommandLineSetup.access$getCommandLineContent$p(this.this$0).put(resolvedTargetPath, FileUtil.loadFile((File)this.$localFile));
                }
                catch (IOException e) {
                    com.intellij.openapi.projectRoots.JdkCommandLineSetup$Companion.access$getLOG$p(JdkCommandLineSetup.Companion).error("Cannot add command line content for " + resolvedTargetPath + " from " + this.$localFile, (Throwable)e);
                }
            }
            {
                this.this$0 = jdkCommandLineSetup;
                this.$localFile = file;
            }
        });
    }

    private final void appendVmParameters(ParametersList vmParameters) {
        Iterable $this$forEach$iv = vmParameters.getList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.appendVmParameter(it);
        }
    }

    private final void appendVmParameter(String vmParameter) {
        if (this.request instanceof LocalTargetEnvironmentRequest || SystemProperties.getBooleanProperty((String)"run.targets.ignore.vm.parameter", (boolean)false)) {
            this.commandLine.addParameter(vmParameter);
            return;
        }
        if (StringsKt.startsWith$default((String)vmParameter, (String)"-agentpath:", (boolean)false, (int)2, null)) {
            this.appendVmAgentParameter(vmParameter, "-agentpath:");
        } else if (StringsKt.startsWith$default((String)vmParameter, (String)"-javaagent:", (boolean)false, (int)2, null)) {
            this.appendVmAgentParameter(vmParameter, "-javaagent:");
        } else {
            this.commandLine.addParameter(vmParameter);
        }
    }

    private final void appendVmAgentParameter(String vmParameter, String prefix) {
        String string;
        String path2;
        String string2;
        boolean bl;
        String value = StringUtil.trimStart((String)vmParameter, (String)prefix);
        int equalsSign = StringsKt.indexOf$default((CharSequence)value, (char)'=', (int)0, (boolean)false, (int)6, null);
        if (equalsSign > -1) {
            String string3 = value;
            int n = 0;
            bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, equalsSign);
            string2 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = path2 = value;
        }
        if (!StringsKt.endsWith$default((String)path2, (String)".jar", (boolean)false, (int)2, null)) {
            return;
        }
        if (equalsSign > -1) {
            String string6 = value;
            bl = false;
            String string7 = string6;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string8 = string7.substring(equalsSign);
            string = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).substring(startIndex)");
        } else {
            string = "";
        }
        String suffix = string;
        this.commandLine.addParameter(TargetValue.map(this.getAgentVolume().createUpload(path2), (Function)new Function<String, String>(prefix, suffix){
            final /* synthetic */ String $prefix;
            final /* synthetic */ String $suffix;

            public final String fun(@NotNull String v) {
                return this.$prefix + v + this.$suffix;
            }
            {
                this.$prefix = string;
                this.$suffix = string2;
            }
        }));
    }

    private final void appendEncoding(SimpleJavaParameters javaParameters, ParametersList parametersList) {
        String encoding = parametersList.getPropertyValue("file.encoding");
        if (encoding == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            Charset charset2 = charset;
            this.commandLine.addParameter("-Dfile.encoding=" + charset2.name());
            this.commandLine.setCharset(charset2);
        } else {
            try {
                this.commandLine.setCharset(Charset.forName(encoding));
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                // empty catch block
            }
        }
    }

    private final void appendModulePath(SimpleJavaParameters javaParameters, ParametersList vmParameters) {
        PathsList modulePath = javaParameters.getModulePath();
        if (!modulePath.isEmpty() && !JdkCommandLineSetup.Companion.isExplicitModulePath(vmParameters)) {
            this.commandLine.addParameter("-p");
            this.commandLine.addParameter(this.composeClassPathValues(javaParameters, modulePath));
        }
    }

    private final void appendParamsEncodingClasspath(SimpleJavaParameters javaParameters, ParametersList vmParameters) {
        this.appendVmParameters(vmParameters);
        this.appendEncoding(javaParameters, vmParameters);
        PathsList classPath = javaParameters.getClassPath();
        if (!classPath.isEmpty() && !JdkCommandLineSetup.Companion.isExplicitClassPath(vmParameters)) {
            this.commandLine.addParameter("-classpath");
            this.commandLine.addParameter(this.composeClassPathValues(javaParameters, classPath));
        }
        this.appendModulePath(javaParameters, vmParameters);
    }

    private final TargetValue<String> composeClassPathValues(SimpleJavaParameters javaParameters, PathsList classPath) {
        List<TargetValue<String>> pathValues = this.getClassPathValues(javaParameters, classPath);
        String separator = String.valueOf(this.platform.pathSeparator);
        return TargetValue.composite((Collection)pathValues, (Function)new Function<Collection<String>, String>(separator){
            final /* synthetic */ String $separator;

            public final String fun(Collection<String> values) {
                return ((StringBuilder)CollectionsKt.joinTo$default((Iterable)values, (Appendable)new StringBuilder(), (CharSequence)this.$separator, null, null, (int)0, null, null, (int)124, null)).toString();
            }
            {
                this.$separator = string;
            }
        });
    }

    private final List<TargetValue<String>> getClassPathValues(SimpleJavaParameters javaParameters, PathsList classPath) {
        Sdk sdk = javaParameters.getJdk();
        String localJdkPath = sdk != null ? sdk.getHomePath() : null;
        JavaLanguageRuntimeConfiguration javaLanguageRuntimeConfiguration = this.languageRuntime;
        String remoteJdkPath = javaLanguageRuntimeConfiguration != null ? javaLanguageRuntimeConfiguration.getHomePath() : null;
        ArrayList<TargetValue<String>> result = new ArrayList<TargetValue<String>>();
        for (String path2 : classPath.getPathList()) {
            if (localJdkPath == null || remoteJdkPath == null || !StringsKt.startsWith$default((String)path2, (String)localJdkPath, (boolean)false, (int)2, null)) {
                result.add(this.getClassPathVolume().createUpload(path2));
                continue;
            }
            char separator = this.platform.fileSeparator;
            result.add(TargetValue.fixed(FileUtil.toCanonicalPath((String)(remoteJdkPath + separator + StringUtil.trimStart((String)path2, (String)localJdkPath)), (char)separator)));
        }
        return result;
    }

    private final TargetValue<String> composePathsList(Collection<? extends TargetValue<String>> targetPaths) {
        return TargetValue.composite(targetPaths, (Function)new Function<Collection<String>, String>(this){
            final /* synthetic */ JdkCommandLineSetup this$0;

            public final String fun(Collection<String> it) {
                return ((StringBuilder)CollectionsKt.joinTo$default((Iterable)it, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.this$0.getPlatform().pathSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
            }
            {
                this.this$0 = jdkCommandLineSetup;
            }
        });
    }

    private final String joinPath(String[] segments) {
        return ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.platform.fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
    }

    public JdkCommandLineSetup(@NotNull TargetEnvironmentRequest request, @Nullable TargetEnvironmentConfiguration target) {
        this.request = request;
        this.target = target;
        this.commandLine = new TargetedCommandLineBuilder(this.request);
        this.platform = this.request.getTargetPlatform().getPlatform();
        Object object = this.target;
        this.languageRuntime = object != null && (object = ((TargetEnvironmentConfiguration)object).getRuntimes()) != null ? ((ContributedConfigurationsList)object).findByType(JavaLanguageRuntimeConfiguration.class) : null;
        this.classPathVolume$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetEnvironmentRequest.Volume>(this){
            final /* synthetic */ JdkCommandLineSetup this$0;

            @NotNull
            public final TargetEnvironmentRequest.Volume invoke() {
                return JdkCommandLineSetup.access$getRequest$p(this.this$0).createTempVolume();
            }
            {
                this.this$0 = jdkCommandLineSetup;
                super(0);
            }
        }));
        this.agentVolume$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TargetEnvironmentRequest.Volume>(this){
            final /* synthetic */ JdkCommandLineSetup this$0;

            @NotNull
            public final TargetEnvironmentRequest.Volume invoke() {
                return JdkCommandLineSetup.access$getRequest$p(this.this$0).createTempVolume();
            }
            {
                this.this$0 = jdkCommandLineSetup;
                super(0);
            }
        }));
        this.commandLineContent$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, String>>(this){
            final /* synthetic */ JdkCommandLineSetup this$0;

            @NotNull
            public final Map<String, String> invoke() {
                boolean bl = false;
                Map map = new LinkedHashMap<K, V>();
                boolean bl2 = false;
                boolean bl3 = false;
                Map it = map;
                boolean bl4 = false;
                this.this$0.getCommandLine().putUserData(JdkUtil.COMMAND_LINE_CONTENT, it);
                return map;
            }
            {
                this.this$0 = jdkCommandLineSetup;
                super(0);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        LOG$delegate = LazyKt.lazy((Function0)Companion.LOG.2.INSTANCE);
    }

    public static final /* synthetic */ Map access$getCommandLineContent$p(JdkCommandLineSetup $this) {
        return $this.getCommandLineContent();
    }

    public static final /* synthetic */ TargetEnvironmentRequest access$getRequest$p(JdkCommandLineSetup $this) {
        return $this.request;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u001e\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u001a\u001a\u00020\u00122\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00120\u0015H\u0002J\u0016\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup$ArgFile;", "", "dynamicVMOptions", "", "dynamicParameters", "charset", "Ljava/nio/charset/Charset;", "platform", "Lcom/intellij/execution/Platform;", "(ZZLjava/nio/charset/Charset;Lcom/intellij/execution/Platform;)V", "file", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "getFile", "()Ljava/io/File;", "myAllPromises", "", "Lorg/jetbrains/concurrency/Promise;", "", "myPromisedOptionValues", "", "Lcom/intellij/execution/target/value/TargetValue;", "myPromisedParameters", "addPromisedParameter", "", "promisedValue", "optionName", "registerPromise", "value", "scheduleWriteFileWhenReady", "javaParameters", "Lcom/intellij/execution/configurations/SimpleJavaParameters;", "vmParameters", "Lcom/intellij/execution/configurations/ParametersList;", "writeArgFileNow", "intellij.platform.lang"})
    private static final class ArgFile {
        @NotNull
        private final File file;
        private final Map<String, TargetValue<String>> myPromisedOptionValues;
        private final List<TargetValue<String>> myPromisedParameters;
        private final List<Promise<String>> myAllPromises;
        private final boolean dynamicVMOptions;
        private final boolean dynamicParameters;
        private final Charset charset;
        private final Platform platform;

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public final void addPromisedParameter(@NonNls @NotNull String optionName, @NotNull TargetValue<String> promisedValue) {
            this.myPromisedOptionValues.put(optionName, promisedValue);
            this.registerPromise(promisedValue);
        }

        public final void addPromisedParameter(@NotNull TargetValue<String> promisedValue) {
            this.myPromisedParameters.add(promisedValue);
            this.registerPromise(promisedValue);
        }

        public final void scheduleWriteFileWhenReady(@NotNull SimpleJavaParameters javaParameters, @NotNull ParametersList vmParameters) {
            Promises.collectResults$default((Collection)this.myAllPromises, (boolean)false, (int)1, null).onSuccess((Consumer)new Consumer<List<? extends String>>(this, javaParameters, vmParameters){
                final /* synthetic */ ArgFile this$0;
                final /* synthetic */ SimpleJavaParameters $javaParameters;
                final /* synthetic */ ParametersList $vmParameters;

                public final void accept(List<String> it) {
                    try {
                        ArgFile.access$writeArgFileNow(this.this$0, this.$javaParameters, this.$vmParameters);
                    }
                    catch (IOException iOException) {
                    }
                    catch (ExecutionException e) {
                        com.intellij.openapi.projectRoots.JdkCommandLineSetup$Companion.access$getLOG$p(JdkCommandLineSetup.Companion).error("Couldn't resolve target value", (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        com.intellij.openapi.projectRoots.JdkCommandLineSetup$Companion.access$getLOG$p(JdkCommandLineSetup.Companion).error("Couldn't resolve target value", (Throwable)e);
                    }
                }
                {
                    this.this$0 = argFile;
                    this.$javaParameters = simpleJavaParameters;
                    this.$vmParameters = parametersList;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final void writeArgFileNow(SimpleJavaParameters javaParameters, ParametersList vmParameters) throws IOException, ExecutionException, TimeoutException {
            List fileArgs = new ArrayList();
            if (this.dynamicVMOptions) {
                fileArgs.addAll(vmParameters.getList());
            }
            Object object = this.myPromisedOptionValues;
            boolean bl = false;
            Iterator<Object> iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void nextOption;
                Map.Entry<String, TargetValue<String>> entry;
                Map.Entry<String, TargetValue<String>> entry2 = entry = iterator.next();
                boolean bl2 = false;
                object = entry2.getKey();
                entry2 = entry;
                bl2 = false;
                TargetValue<String> nextResolvedValue = entry2.getValue();
                fileArgs.add(nextOption);
                fileArgs.add(nextResolvedValue.getTargetValue().blockingGet(0));
            }
            for (TargetValue targetValue : this.myPromisedParameters) {
                fileArgs.add(targetValue.getTargetValue().blockingGet(0));
            }
            if (this.dynamicParameters) {
                fileArgs.addAll(javaParameters.getProgramParametersList().getList());
            }
            CommandLineWrapperUtil.writeArgumentsFile((File)this.file, (List)fileArgs, (String)this.platform.lineSeparator, (Charset)this.charset);
        }

        private final void registerPromise(TargetValue<String> value) {
            this.myAllPromises.add(value.getTargetValue());
        }

        public ArgFile(boolean dynamicVMOptions, boolean dynamicParameters, @NotNull Charset charset, @NotNull Platform platform) throws IOException {
            this.dynamicVMOptions = dynamicVMOptions;
            this.dynamicParameters = dynamicParameters;
            this.charset = charset;
            this.platform = platform;
            this.file = FileUtil.createTempFile((String)("idea_arg_file" + new Random().nextInt(Integer.MAX_VALUE)), null);
            this.myPromisedOptionValues = new LinkedHashMap();
            boolean bl = false;
            this.myPromisedParameters = new ArrayList();
            bl = false;
            this.myAllPromises = new ArrayList();
        }

        public static final /* synthetic */ void access$writeArgFileNow(ArgFile $this, SimpleJavaParameters javaParameters, ParametersList vmParameters) {
            $this.writeArgFileNow(javaParameters, vmParameters);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\b\u0002\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0014H\u0002J(\u0010\u0019\u001a\u00020\u00122\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cJ*\u0010\u001e\u001a\u00020\u00122\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0002R\u0019\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup$ClasspathJar;", "", "setup", "Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup;", "notEscapeClassPathUrl", "", "(Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup;Z)V", "file", "Ljava/io/File;", "Lorg/jetbrains/annotations/NotNull;", "getFile$intellij_platform_lang", "()Ljava/io/File;", "manifest", "Ljava/util/jar/Manifest;", "manifestText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "addToManifest", "", "key", "", "value", "skipInCommandLineContent", "pathToUrl", "path", "scheduleWriteFileWhenClassPathReady", "classpath", "", "Lcom/intellij/execution/target/value/TargetValue;", "selfUpload", "writeFileNow", "resolvedTargetClasspath", "intellij.platform.lang"})
    public static final class ClasspathJar {
        private final Manifest manifest;
        private final StringBuilder manifestText;
        @NotNull
        private final File file;
        private final JdkCommandLineSetup setup;
        private final boolean notEscapeClassPathUrl;

        @NotNull
        public final File getFile$intellij_platform_lang() {
            return this.file;
        }

        public final void addToManifest(@NotNull String key, @NotNull String value, boolean skipInCommandLineContent) {
            this.manifest.getMainAttributes().putValue(key, value);
            if (!skipInCommandLineContent) {
                this.manifestText.append(key).append(": ").append(value).append("\n");
            }
        }

        public static /* synthetic */ void addToManifest$default(ClasspathJar classpathJar, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            classpathJar.addToManifest(string, string2, bl);
        }

        /*
         * WARNING - void declaration
         */
        public final void scheduleWriteFileWhenClassPathReady(@NotNull List<? extends TargetValue<String>> classpath, @NotNull TargetValue<String> selfUpload) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = classpath;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TargetValue targetValue = (TargetValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Promise promise = it.getTargetValue();
                collection.add(promise);
            }
            Promises.collectResults$default((Collection)((List)destination$iv$iv), (boolean)false, (int)1, null).onSuccess((Consumer)new Consumer<List<? extends String>>(this, classpath, selfUpload){
                final /* synthetic */ ClasspathJar this$0;
                final /* synthetic */ List $classpath;
                final /* synthetic */ TargetValue $selfUpload;

                public final void accept(List<String> it) {
                    try {
                        ClasspathJar.access$writeFileNow(this.this$0, this.$classpath, this.$selfUpload);
                    }
                    catch (IOException iOException) {
                    }
                    catch (ExecutionException e) {
                        com.intellij.openapi.projectRoots.JdkCommandLineSetup$Companion.access$getLOG$p(JdkCommandLineSetup.Companion).error("Couldn't resolve target value", (Throwable)e);
                    }
                    catch (TimeoutException e) {
                        com.intellij.openapi.projectRoots.JdkCommandLineSetup$Companion.access$getLOG$p(JdkCommandLineSetup.Companion).error("Couldn't resolve target value", (Throwable)e);
                    }
                }
                {
                    this.this$0 = classpathJar;
                    this.$classpath = list;
                    this.$selfUpload = targetValue;
                }
            });
        }

        private final void writeFileNow(List<? extends TargetValue<String>> resolvedTargetClasspath, TargetValue<String> selfUpload) throws ExecutionException, TimeoutException, IOException {
            StringBuilder classPath = new StringBuilder();
            for (TargetValue<String> targetValue : resolvedTargetClasspath) {
                CharSequence charSequence = classPath;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    classPath.append(' ');
                }
                String localValue = targetValue.getLocalValue().blockingGet(0);
                String targetValue2 = targetValue.getTargetValue().blockingGet(0);
                if (targetValue2 == null || localValue == null) {
                    throw (Throwable)new ExecutionException("Couldn't resolve target value", null);
                }
                String targetUrl = this.pathToUrl(targetValue2);
                classPath.append(targetUrl);
                if (StringUtil.endsWithChar((CharSequence)targetUrl, (char)'/') || !new File(localValue).isDirectory()) continue;
                classPath.append('/');
            }
            CommandLineWrapperUtil.fillClasspathJarFile((Manifest)this.manifest, (String)classPath.toString(), (File)this.file);
            selfUpload.getTargetValue().onSuccess(new Consumer<String>(this, classPath){
                final /* synthetic */ ClasspathJar this$0;
                final /* synthetic */ StringBuilder $classPath;

                public final void accept(@NotNull String value) {
                    String fullManifestText = ClasspathJar.access$getManifestText$p(this.this$0).toString() + "Class-Path: " + this.$classPath.toString();
                    JdkCommandLineSetup.access$getCommandLineContent$p(ClasspathJar.access$getSetup$p(this.this$0)).put(value, fullManifestText);
                }
                {
                    this.this$0 = classpathJar;
                    this.$classPath = stringBuilder;
                }
            });
        }

        private final String pathToUrl(String path2) throws MalformedURLException {
            File file = new File(path2);
            URL url = this.notEscapeClassPathUrl ? file.toURL() : file.toURI().toURL();
            return url.toString();
        }

        public ClasspathJar(@NotNull JdkCommandLineSetup setup, boolean notEscapeClassPathUrl) throws IOException {
            this.setup = setup;
            this.notEscapeClassPathUrl = notEscapeClassPathUrl;
            this.manifest = new Manifest();
            this.manifestText = new StringBuilder();
            int n = new Random().nextInt();
            boolean bl = false;
            this.file = FileUtil.createTempFile((String)("classpath" + Math.abs(n)), (String)".jar", (boolean)true);
        }

        public static final /* synthetic */ void access$writeFileNow(ClasspathJar $this, List resolvedTargetClasspath, TargetValue selfUpload) {
            $this.writeFileNow(resolvedTargetClasspath, selfUpload);
        }

        public static final /* synthetic */ StringBuilder access$getManifestText$p(ClasspathJar $this) {
            return $this.manifestText;
        }

        public static final /* synthetic */ JdkCommandLineSetup access$getSetup$p(ClasspathJar $this) {
            return $this.setup;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\f\u0010\u0015\u001a\u00020\u000f*\u00020\u0016H\u0002J\f\u0010\u0017\u001a\u00020\u000f*\u00020\u0016H\u0002J\f\u0010\u0018\u001a\u00020\u000f*\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0019"}, d2={"Lcom/intellij/openapi/projectRoots/JdkCommandLineSetup$Companion;", "", "()V", "JAVAAGENT", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOG$delegate", "Lkotlin/Lazy;", "commandLineWrapperClass", "Ljava/lang/Class;", "isUserDefinedProperty", "", "param", "throwUnableToCreateTempFile", "", "cause", "Ljava/io/IOException;", "isExplicitClassPath", "Lcom/intellij/execution/configurations/ParametersList;", "isExplicitModulePath", "isUrlClassloader", "intellij.platform.lang"})
    public static final class Companion {
        private final Logger getLOG() {
            Lazy lazy = LOG$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Logger)lazy.getValue();
        }

        private final Class<?> commandLineWrapperClass() {
            try {
                return Class.forName("com.intellij.rt.execution.CommandLineWrapper");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private final boolean isExplicitClassPath(ParametersList $this$isExplicitClassPath) {
            return $this$isExplicitClassPath.hasParameter("-cp") || $this$isExplicitClassPath.hasParameter("-classpath") || $this$isExplicitClassPath.hasParameter("--class-path");
        }

        private final boolean isUrlClassloader(ParametersList $this$isUrlClassloader) {
            return Intrinsics.areEqual((Object)UrlClassLoader.class.getName(), (Object)$this$isUrlClassloader.getPropertyValue("java.system.class.loader"));
        }

        private final boolean isExplicitModulePath(ParametersList $this$isExplicitModulePath) {
            return $this$isExplicitModulePath.hasParameter("-p") || $this$isExplicitModulePath.hasParameter("--module-path");
        }

        private final boolean isUserDefinedProperty(String param) {
            return StringsKt.startsWith$default((String)param, (String)"-D", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)param, (String)"-Dsun.", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)param, (String)"-Djava.", (boolean)false, (int)2, null);
        }

        private final void throwUnableToCreateTempFile(IOException cause) throws CantRunException {
            throw (Throwable)((Object)new CantRunException("Failed to create a temporary file in " + FileUtilRt.getTempDirectory(), cause));
        }

        private Companion() {
        }

        public static final /* synthetic */ Logger access$getLOG$p(Companion $this) {
            return $this.getLOG();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

