/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.containers.MultiMap;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class ModuleUtil
extends ModuleUtilCore {
    private static final ParameterizedCachedValueProvider<MultiMap<ModuleType<?>, Module>, Project> MODULE_BY_TYPE_VALUE_PROVIDER = param -> {
        MultiMap map = new MultiMap();
        for (Module module : ModuleManager.getInstance(param).getModules()) {
            map.putValue(ModuleType.get(module), (Object)module);
        }
        return CachedValueProvider.Result.createSingleDependency(map, ProjectRootManager.getInstance(param));
    };
    private static final ParameterizedCachedValueProvider<Boolean, Project> HAS_TEST_ROOTS_PROVIDER = project -> {
        boolean hasTestRoots = Arrays.stream(ModuleManager.getInstance(project).getModules()).flatMap(module -> Arrays.stream(ModuleRootManager.getInstance(module).getContentEntries())).flatMap(entry -> Arrays.stream(entry.getSourceFolders())).anyMatch(folder -> folder.getRootType().isForTests());
        return CachedValueProvider.Result.createSingleDependency(hasTestRoots, ProjectRootManager.getInstance(project));
    };
    private static final Key<ParameterizedCachedValue<MultiMap<ModuleType<?>, Module>, Project>> MODULES_BY_TYPE_KEY = Key.create((String)"MODULES_BY_TYPE");
    private static final Key<ParameterizedCachedValue<Boolean, Project>> HAS_TEST_ROOTS_KEY = Key.create((String)"HAS_TEST_ROOTS");

    private ModuleUtil() {
    }

    @NotNull
    public static Collection<Module> getModulesOfType(@NotNull Project project, @NotNull ModuleType<?> moduleType) {
        return CachedValuesManager.getManager(project).getParameterizedCachedValue((UserDataHolder)project, MODULES_BY_TYPE_KEY, MODULE_BY_TYPE_VALUE_PROVIDER, false, project).get(moduleType);
    }

    public static boolean hasModulesOfType(@NotNull Project project, @NotNull ModuleType<?> module) {
        return !ModuleUtil.getModulesOfType(project, module).isEmpty();
    }

    public static boolean hasTestSourceRoots(@NotNull Project project) {
        return CachedValuesManager.getManager(project).getParameterizedCachedValue((UserDataHolder)project, HAS_TEST_ROOTS_KEY, HAS_TEST_ROOTS_PROVIDER, false, project);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public static ModuleType<?> getModuleType(@NotNull Module module) {
        return ModuleType.get(module);
    }
}

