/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface FileEditorProvider {
    public static final ExtensionPointName<FileEditorProvider> EP_FILE_EDITOR_PROVIDER = new ExtensionPointName("com.intellij.fileEditorProvider");
    public static final Key<FileEditorProvider> KEY = Key.create((String)"com.intellij.fileEditorProvider");

    public boolean accept(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public FileEditor createEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    default public void disposeEditor(@NotNull FileEditor editor) {
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    default public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        return FileEditorState.INSTANCE;
    }

    default public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
    }

    @NotNull
    @NonNls
    public String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy();
}

