/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.SystemProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemExecutionSettings
implements Serializable,
UserDataHolder {
    public static final String REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY = "external.system.remote.process.idle.ttl.ms";
    private static final int DEFAULT_REMOTE_PROCESS_TTL_MS = -1;
    private static final long serialVersionUID = 1L;
    private long myRemoteProcessIdleTtlInMs;
    private boolean myVerboseProcessing;
    @NotNull
    private final List<String> myJvmArguments;
    @NotNull
    private final List<String> myArguments;
    @NotNull
    private final Map<String, String> myEnv;
    private boolean myPassParentEnvs = true;
    @NotNull
    private final transient UserDataHolderBase myUserData = new UserDataHolderBase();

    public ExternalSystemExecutionSettings() {
        int ttl = SystemProperties.getIntProperty((String)REMOTE_PROCESS_IDLE_TTL_IN_MS_KEY, (int)-1);
        this.setRemoteProcessIdleTtlInMs(ttl);
        this.myJvmArguments = new ArrayList<String>();
        this.myArguments = new ArrayList<String>();
        this.myEnv = new LinkedHashMap<String, String>();
    }

    public long getRemoteProcessIdleTtlInMs() {
        return this.myRemoteProcessIdleTtlInMs;
    }

    public void setRemoteProcessIdleTtlInMs(long remoteProcessIdleTtlInMs) {
        this.myRemoteProcessIdleTtlInMs = remoteProcessIdleTtlInMs;
    }

    public boolean isVerboseProcessing() {
        return this.myVerboseProcessing;
    }

    public void setVerboseProcessing(boolean verboseProcessing) {
        this.myVerboseProcessing = verboseProcessing;
    }

    @Deprecated
    @NotNull
    @ApiStatus.ScheduledForRemoval(inVersion="2020.1")
    public Set<String> getVmOptions() {
        return new LinkedHashSet<String>(this.myJvmArguments);
    }

    @NotNull
    public List<String> getJvmArguments() {
        return Collections.unmodifiableList(this.myJvmArguments);
    }

    @NotNull
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.myArguments);
    }

    @NotNull
    public Map<String, String> getEnv() {
        return Collections.unmodifiableMap(this.myEnv);
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public ExternalSystemExecutionSettings withVmOptions(Collection<String> vmOptions) {
        this.myJvmArguments.addAll(vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOptions(String ... vmOptions) {
        Collections.addAll(this.myJvmArguments, vmOptions);
        return this;
    }

    public ExternalSystemExecutionSettings withVmOption(String vmOption) {
        this.myJvmArguments.add(vmOption);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(Collection<String> arguments) {
        this.myArguments.addAll(arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArguments(String ... arguments) {
        Collections.addAll(this.myArguments, arguments);
        return this;
    }

    public ExternalSystemExecutionSettings withArgument(String argument) {
        this.myArguments.add(argument);
        return this;
    }

    public ExternalSystemExecutionSettings withEnvironmentVariables(Map<String, String> envs) {
        this.myEnv.putAll(envs);
        return this;
    }

    public ExternalSystemExecutionSettings passParentEnvs(boolean passParentEnvs) {
        this.myPassParentEnvs = passParentEnvs;
        return this;
    }

    @Nullable
    public <U> U getUserData(@NotNull Key<U> key) {
        return (U)this.myUserData.getUserData(key);
    }

    public <U> void putUserData(@NotNull Key<U> key, U value) {
        this.myUserData.putUserData(key, value);
    }

    public int hashCode() {
        int result = (int)(this.myRemoteProcessIdleTtlInMs ^ this.myRemoteProcessIdleTtlInMs >>> 32);
        result = 31 * result + (this.myVerboseProcessing ? 1 : 0);
        result = 31 * result + this.myJvmArguments.hashCode();
        result = 31 * result + this.myArguments.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSystemExecutionSettings that = (ExternalSystemExecutionSettings)o;
        if (this.myRemoteProcessIdleTtlInMs != that.myRemoteProcessIdleTtlInMs) {
            return false;
        }
        if (this.myVerboseProcessing != that.myVerboseProcessing) {
            return false;
        }
        if (!this.myJvmArguments.equals(that.myJvmArguments)) {
            return false;
        }
        return this.myArguments.equals(that.myArguments);
    }
}

