/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import com.intellij.util.containers.Interner;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LibraryData
extends AbstractNamedData
implements Named,
ProjectCoordinate {
    private static final Interner<String> ourPathInterner = Interner.createWeakInterner();
    private final Map<LibraryPathType, Set<String>> paths = new EnumMap<LibraryPathType, Set<String>>(LibraryPathType.class);
    private final boolean unresolved;
    private String group;
    private String artifactId;
    private String version;

    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String name) {
        this(owner, name, false);
    }

    @PropertyMapping(value={"owner", "externalName", "unresolved"})
    public LibraryData(@NotNull ProjectSystemId owner, @NotNull String externalName, boolean unresolved) {
        super(owner, externalName, externalName.isEmpty() ? "" : owner.getReadableName() + ": " + externalName);
        this.unresolved = unresolved;
    }

    private LibraryData() {
        super(ProjectSystemId.IDE, "");
        this.unresolved = false;
    }

    @Override
    @Nullable
    public String getGroupId() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    @Override
    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isUnresolved() {
        return this.unresolved;
    }

    @NotNull
    public Set<String> getPaths(@NotNull LibraryPathType type) {
        Set<String> result = this.paths.get((Object)type);
        return result == null ? Collections.emptySet() : result;
    }

    public void addPath(@NotNull LibraryPathType type, @NotNull String path2) {
        Set<String> paths = this.paths.get((Object)type);
        if (paths == null) {
            paths = new LinkedHashSet<String>();
            this.paths.put(type, paths);
        }
        paths.add((String)ourPathInterner.intern((Object)ExternalSystemApiUtil.toCanonicalPath(path2)));
    }

    public void forgetAllPaths() {
        this.paths.clear();
    }

    @Override
    public int hashCode() {
        int result = this.paths.hashCode();
        result = 31 * result + super.hashCode();
        result = 31 * result + (this.unresolved ? 0 : 1);
        result = 31 * result + (this.group != null ? this.group.hashCode() : 0);
        result = 31 * result + (this.artifactId != null ? this.artifactId.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        LibraryData that = (LibraryData)o;
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.artifactId != null ? !this.artifactId.equals(that.artifactId) : that.artifactId != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return super.equals(that) && this.unresolved == that.unresolved && this.paths.equals(that.paths);
    }

    public String toString() {
        String externalName = this.getExternalName();
        String displayName = StringUtil.isEmpty((String)externalName) ? this.paths.toString() : externalName;
        return String.format("library %s%s", displayName, this.unresolved ? "(unresolved)" : "");
    }
}

