/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.execution;

import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ExternalTaskExecutionInfo {
    @NotNull
    private ExternalSystemTaskExecutionSettings mySettings;
    @NotNull
    private String myExecutorId;

    public ExternalTaskExecutionInfo() {
        this(new ExternalSystemTaskExecutionSettings(), "___DUMMY___");
    }

    public ExternalTaskExecutionInfo(@NotNull ExternalSystemTaskExecutionSettings settings, @NotNull String executorId) {
        this.mySettings = settings;
        this.myExecutorId = executorId;
    }

    @NotNull
    public ExternalSystemTaskExecutionSettings getSettings() {
        return this.mySettings;
    }

    public void setSettings(@NotNull ExternalSystemTaskExecutionSettings settings) {
        this.mySettings = settings;
    }

    @NotNull
    public String getExecutorId() {
        return this.myExecutorId;
    }

    public void setExecutorId(@NotNull String executorId) {
        this.myExecutorId = executorId;
    }

    public String getDescription() {
        return StringUtil.join(this.mySettings.getTaskDescriptions(), (String)"\n");
    }

    public int hashCode() {
        int result = this.mySettings.hashCode();
        result = 31 * result + this.myExecutorId.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalTaskExecutionInfo task = (ExternalTaskExecutionInfo)o;
        if (!this.myExecutorId.equals(task.myExecutorId)) {
            return false;
        }
        return this.mySettings.equals(task.mySettings);
    }

    public String toString() {
        return StringUtil.join(this.mySettings.getTaskNames(), (String)" ");
    }
}

