/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.CaretSpecificDataContext;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EditorActionHandler {
    private final boolean myRunForEachCaret;
    private boolean myWorksInInjected;
    private boolean inExecution;
    private boolean inCheck;

    protected EditorActionHandler() {
        this(false);
    }

    protected EditorActionHandler(boolean runForEachCaret) {
        this.myRunForEachCaret = runForEachCaret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isEnabled(Editor editor, DataContext dataContext) {
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            Editor hostEditor;
            if (editor == null) {
                boolean bl = false;
                return bl;
            }
            Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
            if (hostEditor == null) {
                hostEditor = editor;
            }
            boolean[] result = new boolean[1];
            CaretTask check = (___, __) -> {
                result[0] = true;
            };
            if (this.myRunForEachCaret) {
                hostEditor.getCaretModel().runForEachCaret(caret -> this.doIfEnabled(caret, dataContext, check));
            } else {
                this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, check);
            }
            boolean bl = result[0];
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    private void doIfEnabled(@NotNull Caret hostCaret, @Nullable DataContext context, @NotNull CaretTask task) {
        DataContext injectedCaretContext;
        Caret injectedCaret;
        CaretSpecificDataContext caretContext = context == null ? null : new CaretSpecificDataContext(context, hostCaret);
        Editor editor = hostCaret.getEditor();
        if (this.myWorksInInjected && caretContext != null && (injectedCaret = CommonDataKeys.CARET.getData(injectedCaretContext = AnActionEvent.getInjectedDataContext(caretContext))) != null && injectedCaret != hostCaret && this.isEnabledForCaret(injectedCaret.getEditor(), injectedCaret, injectedCaretContext)) {
            task.perform(injectedCaret, injectedCaretContext);
            return;
        }
        if (this.isEnabledForCaret(editor, hostCaret, caretContext)) {
            task.perform(hostCaret, caretContext);
        }
    }

    static boolean ensureInjectionUpToDate(@NotNull Caret hostCaret) {
        Editor editor = hostCaret.getEditor();
        Project project = editor.getProject();
        if (project != null && InjectedLanguageManager.getInstance(project).mightHaveInjectedFragmentAtOffset(editor.getDocument(), hostCaret.getOffset())) {
            PsiDocumentManager.getInstance(project).commitDocument(editor.getDocument());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (this.inCheck) {
            return true;
        }
        this.inCheck = true;
        try {
            boolean bl = this.isEnabled(editor, dataContext);
            return bl;
        }
        finally {
            this.inCheck = false;
        }
    }

    public final boolean isEnabled(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        return caret == null ? this.isEnabled(editor, dataContext) : this.isEnabledForCaret(editor, caret, dataContext);
    }

    @Deprecated
    public void execute(@NotNull Editor editor, @Nullable DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, editor.getCaretModel().getCurrentCaret(), dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
        if (this.inExecution) {
            return;
        }
        try {
            this.inExecution = true;
            this.execute(editor, dataContext);
        }
        finally {
            this.inExecution = false;
        }
    }

    public boolean executeInCommand(@NotNull Editor editor, DataContext dataContext) {
        return true;
    }

    public boolean runForAllCarets() {
        return this.myRunForEachCaret;
    }

    public final void execute(@NotNull Editor editor, @Nullable Caret contextCaret, DataContext dataContext) {
        Editor hostEditor;
        Editor editor2 = hostEditor = dataContext == null ? null : CommonDataKeys.HOST_EDITOR.getData(dataContext);
        if (hostEditor == null) {
            hostEditor = editor;
        }
        if (contextCaret == null && this.runForAllCarets()) {
            hostEditor.getCaretModel().runForEachCaret(caret -> {
                if (this.myWorksInInjected) {
                    EditorActionHandler.ensureInjectionUpToDate(caret);
                }
                this.doIfEnabled(caret, dataContext, (caret1, dc) -> this.doExecute(caret1.getEditor(), caret1, dc));
            });
        } else if (contextCaret == null) {
            if (this.myWorksInInjected) {
                EditorActionHandler.ensureInjectionUpToDate(hostEditor.getCaretModel().getCurrentCaret());
            }
            this.doIfEnabled(hostEditor.getCaretModel().getCurrentCaret(), dataContext, (caret, dc) -> this.doExecute(caret.getEditor(), null, dc));
        } else {
            this.doExecute(editor, contextCaret, dataContext);
        }
    }

    void setWorksInInjected(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public DocCommandGroupId getCommandGroupId(@NotNull Editor editor) {
        return DocCommandGroupId.noneGroupId(editor.getDocument());
    }

    @Nullable
    <T> T getHandlerOfType(@NotNull Class<T> type) {
        return type.isInstance(this) ? (T)type.cast(this) : null;
    }

    @FunctionalInterface
    private static interface CaretTask {
        public void perform(@NotNull Caret var1, @Nullable DataContext var2);
    }
}

