/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretAction;
import com.intellij.openapi.editor.CaretActionListener;
import com.intellij.openapi.editor.CaretState;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CaretModel {
    default public void moveCaretRelatively(int columnShift, int lineShift, boolean withSelection, boolean blockSelection, boolean scrollToCaret) {
        this.getCurrentCaret().moveCaretRelatively(columnShift, lineShift, withSelection, scrollToCaret);
    }

    default public void moveToLogicalPosition(@NotNull LogicalPosition pos) {
        this.getCurrentCaret().moveToLogicalPosition(pos);
    }

    default public void moveToVisualPosition(@NotNull VisualPosition pos) {
        this.getCurrentCaret().moveToVisualPosition(pos);
    }

    default public void moveToOffset(int offset) {
        this.moveToOffset(offset, false);
    }

    default public void moveToOffset(int offset, boolean locateBeforeSoftWrap) {
        this.getCurrentCaret().moveToOffset(offset, locateBeforeSoftWrap);
    }

    default public boolean isUpToDate() {
        return this.getCurrentCaret().isUpToDate();
    }

    @NotNull
    default public LogicalPosition getLogicalPosition() {
        return this.getCurrentCaret().getLogicalPosition();
    }

    @NotNull
    default public VisualPosition getVisualPosition() {
        return this.getCurrentCaret().getVisualPosition();
    }

    default public int getOffset() {
        return this.getCurrentCaret().getOffset();
    }

    public void addCaretListener(@NotNull CaretListener var1);

    default public void addCaretListener(@NotNull CaretListener listener2, @NotNull Disposable parentDisposable) {
        this.addCaretListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeCaretListener(listener2));
    }

    public void removeCaretListener(@NotNull CaretListener var1);

    default public int getVisualLineStart() {
        return this.getCurrentCaret().getVisualLineStart();
    }

    default public int getVisualLineEnd() {
        return this.getCurrentCaret().getVisualLineEnd();
    }

    public TextAttributes getTextAttributes();

    public boolean supportsMultipleCarets();

    @NotNull
    public Caret getCurrentCaret();

    @NotNull
    public Caret getPrimaryCaret();

    public int getCaretCount();

    @NotNull
    public List<Caret> getAllCarets();

    @Nullable
    public Caret getCaretAt(@NotNull VisualPosition var1);

    @Nullable
    default public Caret addCaret(@NotNull VisualPosition pos) {
        return this.addCaret(pos, true);
    }

    @Nullable
    public Caret addCaret(@NotNull VisualPosition var1, boolean var2);

    @Nullable
    public Caret addCaret(@NotNull LogicalPosition var1, boolean var2);

    public boolean removeCaret(@NotNull Caret var1);

    public void removeSecondaryCarets();

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> var1);

    public void setCaretsAndSelections(@NotNull List<? extends CaretState> var1, boolean var2);

    @NotNull
    public List<CaretState> getCaretsAndSelections();

    public void runForEachCaret(@NotNull CaretAction var1);

    public void runForEachCaret(@NotNull CaretAction var1, boolean var2);

    public void addCaretActionListener(@NotNull CaretActionListener var1, @NotNull Disposable var2);

    public void runBatchCaretOperation(@NotNull Runnable var1);
}

