/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ExperimentalFeature;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.NonUrgentExecutor;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class Experiments {
    public static final ExtensionPointName<ExperimentalFeature> EP_NAME = ExtensionPointName.create((String)"com.intellij.experimentalFeature");
    private static final Logger LOG = Logger.getInstance(Experiments.class);
    private final Map<String, Boolean> cache = new ConcurrentHashMap<String, Boolean>();

    public Experiments() {
        NonUrgentExecutor.getInstance().execute(() -> {
            SmartList enabledIds = new SmartList();
            PropertiesComponent propertyManager = PropertiesComponent.getInstance();
            for (ExperimentalFeature feature : EP_NAME.getExtensionList()) {
                Boolean result = this.cache.get(feature.id);
                if (result == null) {
                    result = Experiments.calcIsFeatureEnabled(feature, propertyManager);
                    this.cache.put(feature.id, result);
                }
                if (!result.booleanValue()) continue;
                enabledIds.add(feature.id);
            }
            if (!enabledIds.isEmpty()) {
                LOG.info("Experimental features enabled for user: " + StringUtil.join((Collection)enabledIds, (String)", "));
            }
        });
    }

    @NotNull
    public static Experiments getInstance() {
        return (Experiments)ApplicationManager.getApplication().getService(Experiments.class);
    }

    public boolean isFeatureEnabled(@NonNls @NotNull String featureId) {
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return false;
        }
        Boolean result = this.cache.get(featureId);
        if (result == null) {
            ExperimentalFeature feature = Experiments.getFeatureById(featureId);
            result = feature != null && Experiments.calcIsFeatureEnabled(feature, PropertiesComponent.getInstance());
            this.cache.put(featureId, result);
        }
        return result;
    }

    private static boolean calcIsFeatureEnabled(@NotNull ExperimentalFeature feature, @NotNull PropertiesComponent propertyManager) {
        String key = Experiments.toPropertyKey(feature);
        return propertyManager.isValueSet(key) ? propertyManager.getBoolean(key, false) : feature.isEnabled();
    }

    public void setFeatureEnabled(@NotNull String featureId, boolean enabled) {
        ExperimentalFeature feature = Experiments.getFeatureById(featureId);
        if (feature != null) {
            this.cache.put(featureId, enabled);
            String key = Experiments.toPropertyKey(feature);
            PropertiesComponent.getInstance().setValue(key, enabled, feature.isEnabled());
            LOG.info("Experimental feature '" + featureId + "' is now turned " + (enabled ? "ON" : "OFF"));
        }
    }

    @Nullable
    private static ExperimentalFeature getFeatureById(@NotNull String featureId) {
        if (!LoadingState.COMPONENTS_REGISTERED.isOccurred()) {
            return null;
        }
        return (ExperimentalFeature)EP_NAME.findFirstSafe(feature -> feature.id.equals(featureId));
    }

    public boolean isChanged(@NotNull String featureId) {
        ExperimentalFeature feature = Experiments.getFeatureById(featureId);
        return feature != null && feature.isEnabled() != this.isFeatureEnabled(featureId);
    }

    private static String toPropertyKey(@NotNull ExperimentalFeature feature) {
        return "experimentalFeature." + feature.id;
    }
}

