/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.ex;

import com.intellij.ide.DataManager;
import com.intellij.ide.actions.ActionsCollector;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PausesStat;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionUtil {
    private static final Logger LOG = Logger.getInstance(ActionUtil.class);
    @NonNls
    private static final String WAS_ENABLED_BEFORE_DUMB = "WAS_ENABLED_BEFORE_DUMB";
    @NonNls
    public static final String WOULD_BE_ENABLED_IF_NOT_DUMB_MODE = "WOULD_BE_ENABLED_IF_NOT_DUMB_MODE";
    @NonNls
    private static final String WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE = "WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE";
    @NonNls
    private static final Key<ActionUpdateData> ACTION_UPDATE_DATA = Key.create((String)"ACTION_UPDATE_DATA");
    private static int insidePerformDumbAwareUpdate;

    private ActionUtil() {
    }

    public static void showDumbModeWarning(AnActionEvent ... events) {
        Project project = null;
        ArrayList<String> actionNames = new ArrayList<String>();
        for (AnActionEvent event : events) {
            Project _project;
            String s = event.getPresentation().getText();
            if (StringUtil.isNotEmpty((String)s)) {
                actionNames.add(s);
            }
            if ((_project = event.getProject()) == null || project != null) continue;
            project = _project;
        }
        if (project == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Showing dumb mode warning for " + Arrays.asList(events), new Throwable());
        }
        DumbService.getInstance(project).showDumbModeNotification(ActionUtil.getActionUnavailableMessage(actionNames));
    }

    @NotNull
    private static String getActionUnavailableMessage(@NotNull List<String> actionNames) {
        String message = actionNames.isEmpty() ? ActionUtil.getUnavailableMessage("This action", false) : (actionNames.size() == 1 ? ActionUtil.getUnavailableMessage("'" + actionNames.get(0) + "'", false) : ActionUtil.getUnavailableMessage("None of the following actions", true) + ": " + StringUtil.join(actionNames, (String)", "));
        return message;
    }

    @NotNull
    public static String getUnavailableMessage(@NotNull String action, boolean plural) {
        return action + (plural ? " are" : " is") + " not available while " + ApplicationNamesInfo.getInstance().getProductName() + " is updating indices";
    }

    public static void performFastUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent event, boolean forceUseCached) {
        long finishUpdateNs;
        Presentation templatePresentation = action.getTemplatePresentation();
        ActionUpdateData ud = templatePresentation.getClientProperty(ACTION_UPDATE_DATA);
        if (ud == null) {
            ud = new ActionUpdateData();
            templatePresentation.putClientProperty(ACTION_UPDATE_DATA, ud);
        }
        boolean isSlow = ud.averageUpdateDurationMs > 10L;
        long startTimeNs = System.nanoTime();
        long relaxMs = Math.min(ud.averageUpdateDurationMs * 100L, 10000L);
        if (isSlow && ud.lastUpdateEvent != null && (forceUseCached || (startTimeNs - ud.lastUpdateTimeNs) / 1000000L < relaxMs)) {
            event.getPresentation().copyFrom(ud.lastUpdateEvent.getPresentation());
            return;
        }
        ActionUtil.performDumbAwareUpdate(isInModalContext, action, event, false);
        ud.lastUpdateTimeNs = finishUpdateNs = System.nanoTime();
        ud.lastUpdateEvent = event;
        float smoothAlpha = isSlow ? 0.8f : 0.3f;
        float smoothCoAlpha = 1.0f - smoothAlpha;
        long spentMs = (finishUpdateNs - startTimeNs) / 1000000L;
        ud.averageUpdateDurationMs = Math.round((float)spentMs * smoothAlpha + (float)ud.averageUpdateDurationMs * smoothCoAlpha);
    }

    public static boolean performDumbAwareUpdate(boolean isInModalContext, @NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        Presentation presentation = e.getPresentation();
        if (LightEdit.owns(e.getProject()) && !LightEdit.isActionCompatible(action)) {
            presentation.setEnabledAndVisible(false);
            return false;
        }
        Boolean wasEnabledBefore = (Boolean)presentation.getClientProperty(WAS_ENABLED_BEFORE_DUMB);
        boolean dumbMode = ActionUtil.isDumbMode(e.getProject());
        if (wasEnabledBefore != null && !dumbMode) {
            presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, null);
            presentation.setEnabled(wasEnabledBefore);
            presentation.setVisible(true);
        }
        boolean enabledBeforeUpdate = presentation.isEnabled();
        boolean allowed = !(dumbMode && !action.isDumbAware() || Registry.is((String)"actionSystem.honor.modal.context") && isInModalContext && !action.isEnabledInModalContext());
        String presentationText = presentation.getText();
        boolean edt = ApplicationManager.getApplication().isDispatchThread();
        if (edt && insidePerformDumbAwareUpdate++ == 0) {
            ActionPauses.STAT.started();
        }
        action.applyTextOverride(e);
        try {
            if (beforeActionPerformed) {
                action.beforeActionPerformedUpdate(e);
            } else {
                action.update(e);
            }
            presentation.putClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isEnabled() ? 1 : 0));
            presentation.putClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE, (Object)(!allowed && presentation.isVisible() ? 1 : 0));
        }
        catch (IndexNotReadyException e1) {
            if (!allowed) {
                boolean bl = true;
                return bl;
            }
            throw e1;
        }
        finally {
            if (edt && --insidePerformDumbAwareUpdate == 0) {
                ActionPauses.STAT.finished(presentationText + " action update (" + action.getClass() + ")");
            }
            if (!allowed) {
                if (wasEnabledBefore == null) {
                    presentation.putClientProperty(WAS_ENABLED_BEFORE_DUMB, (Object)enabledBeforeUpdate);
                }
                presentation.setEnabled(false);
            }
        }
        return false;
    }

    @Deprecated
    public static boolean performDumbAwareUpdate(@NotNull AnAction action, @NotNull AnActionEvent e, boolean beforeActionPerformed) {
        return ActionUtil.performDumbAwareUpdate(false, action, e, beforeActionPerformed);
    }

    public static <T> T underModalProgress(@NotNull Project project, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String progressTitle, @NotNull Computable<T> computable) throws ProcessCanceledException {
        DumbService dumbService = DumbService.getInstance(project);
        boolean useAlternativeResolve = dumbService.isAlternativeResolveEnabled();
        ThrowableComputable inReadAction = () -> ApplicationManager.getApplication().runReadAction(computable);
        ThrowableComputable prioritizedRunnable = () -> ProgressManager.getInstance().computePrioritized(inReadAction);
        ThrowableComputable process = useAlternativeResolve ? () -> dumbService.computeWithAlternativeResolveEnabled(prioritizedRunnable) : prioritizedRunnable;
        return ProgressManager.getInstance().runProcessWithProgressSynchronously(process, progressTitle, true, project);
    }

    public static boolean isDumbMode(@Nullable Project project) {
        if (project != null) {
            return DumbService.getInstance(project).isDumb();
        }
        for (Project openProject : ProjectManager.getInstance().getOpenProjects()) {
            if (!DumbService.getInstance(openProject).isDumb()) continue;
            return true;
        }
        return false;
    }

    public static boolean lastUpdateAndCheckDumb(AnAction action, AnActionEvent e, boolean visibilityMatters) {
        ActionUtil.performDumbAwareUpdate(false, action, e, true);
        Project project = e.getProject();
        if (project != null && DumbService.getInstance(project).isDumb() && !action.isDumbAware()) {
            if (Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_ENABLED_IF_NOT_DUMB_MODE))) {
                return false;
            }
            if (visibilityMatters && Boolean.FALSE.equals(e.getPresentation().getClientProperty(WOULD_BE_VISIBLE_IF_NOT_DUMB_MODE))) {
                return false;
            }
            ActionUtil.showDumbModeWarning(e);
            return false;
        }
        if (!e.getPresentation().isEnabled()) {
            return false;
        }
        return !visibilityMatters || e.getPresentation().isVisible();
    }

    public static void performActionDumbAwareWithCallbacks(@NotNull AnAction action, @NotNull AnActionEvent e, @NotNull DataContext context) {
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        manager.fireBeforeActionPerformed(action, context, e);
        ActionUtil.performActionDumbAware(action, e);
        manager.fireAfterActionPerformed(action, context, e);
    }

    public static void performActionDumbAware(AnAction action, AnActionEvent e) {
        try {
            action.actionPerformed(e);
        }
        catch (IndexNotReadyException ex) {
            LOG.info((Throwable)ex);
            ActionUtil.showDumbModeWarning(e);
        }
    }

    @NotNull
    public static AnActionEvent createEmptyEvent() {
        return AnActionEvent.createFromDataContext("unknown", null, dataId -> null);
    }

    public static void sortAlphabetically(@NotNull List<? extends AnAction> list) {
        list.sort((o1, o2) -> Comparing.compare((Comparable)((Object)o1.getTemplateText()), (Comparable)((Object)o2.getTemplateText())));
    }

    public static void moveActionTo(@NotNull List<AnAction> list, @NotNull String actionText, @NotNull String targetActionText, boolean before) {
        if (Objects.equals(actionText, targetActionText)) {
            return;
        }
        int actionIndex = -1;
        int targetIndex = -1;
        for (int i = 0; i < list.size(); ++i) {
            AnAction action = list.get(i);
            if (actionIndex == -1 && Objects.equals(actionText, action.getTemplateText())) {
                actionIndex = i;
            }
            if (targetIndex == -1 && Objects.equals(targetActionText, action.getTemplateText())) {
                targetIndex = i;
            }
            if (actionIndex == -1 || targetIndex == -1) continue;
            if (actionIndex < targetIndex) {
                --targetIndex;
            }
            AnAction anAction = list.remove(actionIndex);
            assert (targetIndex >= 0);
            list.add(before ? targetIndex : targetIndex + 1, anAction);
            return;
        }
    }

    @NotNull
    public static List<AnAction> getActions(@NotNull JComponent component) {
        return ContainerUtil.notNullize((List)((List)ComponentUtil.getClientProperty((JComponent)component, AnAction.ACTIONS_KEY)));
    }

    public static void clearActions(@NotNull JComponent component) {
        ComponentUtil.putClientProperty((JComponent)component, AnAction.ACTIONS_KEY, null);
    }

    public static void copyRegisteredShortcuts(@NotNull JComponent to, @NotNull JComponent from) {
        for (AnAction anAction : ActionUtil.getActions(from)) {
            anAction.registerCustomShortcutSet(anAction.getShortcutSet(), to);
        }
    }

    public static void registerForEveryKeyboardShortcut(@NotNull JComponent component, @NotNull ActionListener action, @NotNull ShortcutSet shortcuts) {
        for (Shortcut shortcut : shortcuts.getShortcuts()) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            KeyboardShortcut ks = (KeyboardShortcut)shortcut;
            KeyStroke first = ks.getFirstKeyStroke();
            KeyStroke second = ks.getSecondKeyStroke();
            if (second != null) continue;
            component.registerKeyboardAction(action, first, 2);
        }
    }

    public static void recursiveRegisterShortcutSet(@NotNull ActionGroup group, @NotNull JComponent component, @Nullable Disposable parentDisposable) {
        for (AnAction action : group.getChildren(null)) {
            if (action instanceof ActionGroup) {
                ActionUtil.recursiveRegisterShortcutSet((ActionGroup)action, component, parentDisposable);
            }
            action.registerCustomShortcutSet(component, parentDisposable);
        }
    }

    public static boolean recursiveContainsAction(@NotNull ActionGroup group, @NotNull AnAction action) {
        return ActionUtil.anyActionFromGroupMatches(group, true, Predicate.isEqual(action));
    }

    public static boolean anyActionFromGroupMatches(@NotNull ActionGroup group, boolean processPopupSubGroups, @NotNull Predicate<? super AnAction> condition) {
        for (AnAction child : group.getChildren(null)) {
            if (condition.test(child)) {
                return true;
            }
            if (!(child instanceof ActionGroup)) continue;
            ActionGroup childGroup = (ActionGroup)child;
            if (!processPopupSubGroups && childGroup.isPopup() || !ActionUtil.anyActionFromGroupMatches(childGroup, processPopupSubGroups, condition)) continue;
            return true;
        }
        return false;
    }

    public static AnAction copyFrom(@NotNull AnAction action, @NotNull @NonNls String actionId) {
        AnAction from = ActionManager.getInstance().getAction(actionId);
        if (from != null) {
            action.copyFrom(from);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action, actionId);
        return action;
    }

    public static AnAction mergeFrom(@NotNull AnAction action, @NotNull String actionId) {
        AnAction a1 = action;
        AnAction a2 = ActionManager.getInstance().getAction(actionId);
        Presentation p1 = a1.getTemplatePresentation();
        Presentation p2 = a2.getTemplatePresentation();
        p1.setIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getIcon(), (Object)p2.getIcon()));
        p1.setDisabledIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getDisabledIcon(), (Object)p2.getDisabledIcon()));
        p1.setSelectedIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getSelectedIcon(), (Object)p2.getSelectedIcon()));
        p1.setHoveredIcon((Icon)ObjectUtils.chooseNotNull((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()));
        if (StringUtil.isEmpty((String)p1.getText())) {
            p1.setTextWithMnemonic(p2.getTextWithPossibleMnemonic());
        }
        p1.setDescription((String)ObjectUtils.chooseNotNull((Object)p1.getDescription(), (Object)p2.getDescription()));
        ShortcutSet ss1 = a1.getShortcutSet();
        if (ss1 == CustomShortcutSet.EMPTY) {
            a1.copyShortcutFrom(a2);
        }
        ActionsCollector.getInstance().onActionConfiguredByActionId(action, actionId);
        return a1;
    }

    public static void invokeAction(@NotNull AnAction action, @NotNull Component component, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        ActionUtil.invokeAction(action, DataManager.getInstance().getDataContext(component), place, inputEvent, onDone);
    }

    public static void invokeAction(@NotNull AnAction action, @NotNull DataContext dataContext, @NotNull String place, @Nullable InputEvent inputEvent, @Nullable Runnable onDone) {
        Presentation presentation = action.getTemplatePresentation().clone();
        AnActionEvent event = new AnActionEvent(inputEvent, dataContext, place, presentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate(false, action, event, true);
        ActionManagerEx manager = ActionManagerEx.getInstanceEx();
        if (event.getPresentation().isEnabled() && event.getPresentation().isVisible()) {
            manager.fireBeforeActionPerformed(action, dataContext, event);
            ActionUtil.performActionDumbAware(action, event);
            if (onDone != null) {
                onDone.run();
            }
            manager.fireAfterActionPerformed(action, dataContext, event);
        }
    }

    @NotNull
    public static ActionListener createActionListener(@NotNull String actionId, @NotNull Component component, @NotNull String place) {
        return e -> {
            AnAction action = ActionManager.getInstance().getAction(actionId);
            if (action == null) {
                LOG.warn("Can not find action by id " + actionId);
                return;
            }
            ActionUtil.invokeAction(action, component, place, null, null);
        };
    }

    @Nullable
    public static ShortcutSet getMnemonicAsShortcut(@NotNull AnAction action) {
        return KeymapUtil.getMnemonicAsShortcut(action.getTemplatePresentation().getMnemonic());
    }

    private static class ActionUpdateData {
        AnActionEvent lastUpdateEvent;
        long lastUpdateTimeNs = 0L;
        long averageUpdateDurationMs = 0L;

        private ActionUpdateData() {
        }
    }

    public static final class ActionPauses {
        public static final PausesStat STAT = new PausesStat("AnAction.update()");
    }
}

