/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.DynamicBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.util.SmartFMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    public static final Supplier<String> NULL_STRING = () -> null;
    private SmartFMap<String, Object> myUserMap = SmartFMap.emptyMap();
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport;
    @NotNull
    private Supplier<String> myDescriptionSupplier = () -> null;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    @NotNull
    private Supplier<TextWithMnemonic> myTextWithMnemonicSupplier = () -> null;
    private boolean myVisible = true;
    private boolean myEnabled = true;
    private boolean myMultipleChoice = false;
    private double myWeight = 0.0;
    @NotNull
    private static final NotNullLazyValue<Boolean> removeMnemonics = NotNullLazyValue.createValue(() -> SystemInfo.isMac && DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions());

    public Presentation() {
    }

    public Presentation(@NotNull @NlsActions.ActionText String text) {
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)text);
    }

    public Presentation(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)((String)dynamicText.get()));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support == null) {
            this.myChangeSupport = support = new PropertyChangeSupport(this);
        }
        support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null) {
            support.removePropertyChangeListener(l);
        }
    }

    public @NlsActions.ActionText String getText() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText();
    }

    public @NlsActions.ActionText String getText(boolean withSuffix) {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText(withSuffix);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(text, mayContainMnemonic));
    }

    public void setText(@Nullable @NlsActions.ActionText String text, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(() -> text, mayContainMnemonic));
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithMnemonic(@Nls(capitalization=Nls.Capitalization.Title) @NotNull Supplier<String> text, boolean mayContainMnemonic) {
        if (!mayContainMnemonic) {
            return () -> Optional.ofNullable(text.get()).map(TextWithMnemonic::fromPlainText).orElse(null);
        }
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if (uiSettings != null && uiSettings.getDisableMnemonicsInControls()) {
            return () -> Optional.ofNullable(text.get()).map(it -> TextWithMnemonic.parse((String)it).dropMnemonic(((Boolean)removeMnemonics.getValue()).booleanValue())).orElse(null);
        }
        return () -> Optional.ofNullable(text.get()).map(it -> TextWithMnemonic.parse((String)it)).orElse(null);
    }

    public void setTextWithMnemonic(@NotNull Supplier<TextWithMnemonic> textWithMnemonicSupplier) {
        String oldText = this.getText();
        int oldMnemonic = this.getMnemonic();
        int oldIndex = this.getDisplayedMnemonicIndex();
        this.myTextWithMnemonicSupplier = textWithMnemonicSupplier;
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.getText());
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.getMnemonic());
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldIndex, this.getDisplayedMnemonicIndex());
    }

    public void setText(@Nullable @NlsActions.ActionText String text) {
        this.setText(() -> text, true);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text) {
        this.setText(text, true);
    }

    @Nullable
    public String getTextWithMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.toString();
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithPossibleMnemonic() {
        return this.myTextWithMnemonicSupplier;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
    }

    public @NlsActions.ActionDescription String getDescription() {
        return this.myDescriptionSupplier.get();
    }

    public void setDescription(@NotNull Supplier<String> dynamicDescription) {
        Supplier<String> oldDescription = this.myDescriptionSupplier;
        this.myDescriptionSupplier = dynamicDescription;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription.get(), this.myDescriptionSupplier.get());
    }

    public void setDescription(@NlsActions.ActionDescription String description) {
        Supplier<String> oldDescriptionSupplier = this.myDescriptionSupplier;
        this.myDescriptionSupplier = () -> description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescriptionSupplier.get(), description);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? 0 : textWithMnemonic.getMnemonic();
    }

    public int getDisplayedMnemonicIndex() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? -1 : textWithMnemonic.getMnemonicIndex();
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible;
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.myVisible);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.myEnabled);
    }

    public final void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (oldValue != newValue && support != null) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireObjectPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null && !Objects.equals(oldValue, newValue)) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myChangeSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(Presentation presentation) {
        if (presentation == this) {
            return;
        }
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
        this.setDescription(presentation.myDescriptionSupplier);
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
        this.setWeight(presentation.getWeight());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet allKeys = new HashSet(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        return (T)this.myUserMap.get((Object)key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value) {
        this.putClientProperty(key.toString(), value);
    }

    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        return this.myUserMap.get((Object)key);
    }

    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value) {
        Object oldValue = this.myUserMap.get((Object)key);
        if (Comparing.equal((Object)oldValue, (Object)value)) {
            return;
        }
        this.myUserMap = value == null ? this.myUserMap.minus((Object)key) : this.myUserMap.plus((Object)key, value);
        this.fireObjectPropertyChange(key, oldValue, value);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    public String toString() {
        return this.getText() + " (" + this.myDescriptionSupplier.get() + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    public void setMultipleChoice(boolean b) {
        this.myMultipleChoice = b;
    }

    public boolean isMultipleChoice() {
        return this.myMultipleChoice;
    }
}

