/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi;

import com.intellij.util.NullableFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ListSelection<T> {
    @NotNull
    private final List<T> myList;
    private final int mySelectedIndex;

    private ListSelection(@NotNull List<T> list, int selectedIndex) {
        this.myList = list;
        this.mySelectedIndex = selectedIndex >= 0 && selectedIndex < list.size() ? selectedIndex : 0;
    }

    @NotNull
    public static <V> ListSelection<V> createAt(@NotNull List<V> list, int selectedIndex) {
        return new ListSelection<V>(list, selectedIndex);
    }

    @NotNull
    public static <V> ListSelection<V> create(@NotNull List<V> list, V selected) {
        return ListSelection.createAt(list, list.indexOf(selected));
    }

    @NotNull
    public static <V> ListSelection<V> create(V @NotNull [] array, V selected) {
        return ListSelection.create(Arrays.asList(array), selected);
    }

    @NotNull
    public static <V> ListSelection<V> createSingleton(@NotNull V element) {
        return ListSelection.createAt(Collections.singletonList(element), 0);
    }

    @NotNull
    public List<T> getList() {
        return this.myList;
    }

    public int getSelectedIndex() {
        return this.mySelectedIndex;
    }

    public boolean isEmpty() {
        return this.myList.isEmpty();
    }

    @NotNull
    public <V> ListSelection<V> map(@NotNull NullableFunction<? super T, ? extends V> convertor) {
        int newSelectionIndex = -1;
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object out;
            if (i == this.mySelectedIndex) {
                newSelectionIndex = result.size();
            }
            if ((out = convertor.fun(this.myList.get(i))) == null) continue;
            result.add(out);
        }
        return new ListSelection(result, newSelectionIndex);
    }
}

