/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.search;

import com.intellij.psi.search.SearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface SearchRequest {
    @NotNull
    public String getSearchString();

    @Nullable
    default public SearchScope getSearchScope() {
        return null;
    }

    @Nullable
    default public SearchScope getInjectionSearchScope() {
        return this.getSearchScope();
    }

    @NotNull
    public static SearchRequest of(@NotNull String searchString) {
        return () -> searchString;
    }

    @NotNull
    public static SearchRequest of(@NotNull String searchString, @NotNull SearchScope searchScope) {
        return SearchRequest.of(searchString, searchScope, searchScope);
    }

    @NotNull
    public static SearchRequest of(final @NotNull String searchString, final @NotNull SearchScope searchScope, final @NotNull SearchScope injectionSearchScope) {
        return new SearchRequest(){

            @Override
            @NotNull
            public String getSearchString() {
                return searchString;
            }

            @Override
            @NotNull
            public SearchScope getSearchScope() {
                return searchScope;
            }

            @Override
            @NotNull
            public SearchScope getInjectionSearchScope() {
                return injectionSearchScope;
            }
        };
    }
}

