/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model.psi;

import com.intellij.diagnostic.PluginException;
import com.intellij.lang.Language;
import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.openapi.extensions.CustomLoadingExtensionPointBean;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.util.xmlb.annotations.Attribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiSymbolReferenceProviderBean
extends CustomLoadingExtensionPointBean<PsiSymbolReferenceProvider> {
    @Attribute
    @RequiredElement
    public String hostLanguage;
    @Attribute
    @RequiredElement
    public String hostElementClass;
    @Attribute
    public String referenceClass = PsiSymbolReference.class.getName();
    @Attribute
    public boolean anyReferenceClass = false;
    @Attribute
    @RequiredElement
    public String targetClass;
    @Attribute
    @RequiredElement
    public String implementationClass;

    @Override
    @Nullable
    protected String getImplementationClassName() {
        return this.implementationClass;
    }

    @NotNull
    public Language getHostLanguage() {
        Language language = Language.findLanguageByID(this.hostLanguage);
        if (language == null) {
            throw new PluginException("Cannot find language '" + this.hostLanguage + "'", this.getPluginDescriptor().getPluginId());
        }
        return language;
    }

    @NotNull
    public Class<? extends PsiExternalReferenceHost> getHostElementClass() {
        return this.loadClass(this.hostElementClass);
    }

    @NotNull
    public Class<? extends PsiSymbolReference> getReferenceClass() {
        return this.loadClass(this.referenceClass);
    }

    @NotNull
    public Class<? extends Symbol> getResolveTargetClass() {
        return this.loadClass(this.targetClass);
    }

    private <T> Class<T> loadClass(@NotNull String fqn) {
        PluginDescriptor pluginDescriptor = this.getPluginDescriptor();
        try {
            return Class.forName(fqn, true, pluginDescriptor.getPluginClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new PluginException(e, pluginDescriptor.getPluginId());
        }
    }
}

