/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.documentation;

import com.intellij.lang.documentation.DocumentationProviderEx;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DocumentationProvider {
    public static final ExtensionPointName<DocumentationProvider> EP_NAME = ExtensionPointName.create((String)"com.intellij.documentationProvider");

    @Nullable
    default public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    default public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    default public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        return null;
    }

    @Nullable
    default public String generateHoverDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        return this.generateDoc(element, originalElement);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.2")
    @Nullable
    default public String generateRenderedDoc(@NotNull PsiElement element) {
        return null;
    }

    @ApiStatus.Experimental
    @Nullable
    default public String generateRenderedDoc(@NotNull PsiDocCommentBase comment) {
        PsiElement target = comment.getOwner();
        return this.generateRenderedDoc(target == null ? comment : target);
    }

    @ApiStatus.Experimental
    default public void collectDocComments(@NotNull PsiFile file, @NotNull @NotNull Consumer<@NotNull PsiDocCommentBase> sink) {
    }

    @ApiStatus.Experimental
    @Nullable
    default public PsiDocCommentBase findDocComment(@NotNull PsiFile file, @NotNull TextRange range) {
        PsiDocCommentBase comment = PsiTreeUtil.getParentOfType(file.findElementAt(range.getStartOffset()), PsiDocCommentBase.class, false);
        return comment == null || !range.equals((Object)comment.getTextRange()) ? null : comment;
    }

    @Nullable
    default public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return null;
    }

    @Nullable
    default public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    @Nullable
    default public PsiElement getCustomDocumentationElement(@NotNull Editor editor, @NotNull PsiFile file, @Nullable PsiElement contextElement, int targetOffset) {
        return this instanceof DocumentationProviderEx ? ((DocumentationProviderEx)this).getCustomDocumentationElement(editor, file, contextElement) : null;
    }
}

