/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.chrome;

import com.intellij.ide.browsers.BrowserSpecificSettings;
import com.intellij.ide.browsers.chrome.ChromeSettingsConfigurable;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChromeSettings
extends BrowserSpecificSettings {
    public static final String USER_DATA_DIR_ARG = "--user-data-dir=";
    public static final String NO_FIRST_RUN_ARG = "--no-first-run";
    public static final String NO_DEFAULT_BROWSER_CHECK_ARG = "--no-default-browser-check";
    public static final String DISABLE_FIRST_RUN_EXPERIENCE_ARG = "--disable-fre";
    @Nullable
    private String myCommandLineOptions;
    @Nullable
    private String myUserDataDirectoryPath;
    private boolean myUseCustomProfile;
    @NotNull
    private Map<String, String> myEnvironmentVariables = new THashMap();

    @Tag(value="user-data-dir")
    @Nullable
    public String getUserDataDirectoryPath() {
        return this.myUserDataDirectoryPath;
    }

    @Tag(value="use-custom-profile")
    public boolean isUseCustomProfile() {
        return this.myUseCustomProfile;
    }

    @Tag(value="command-line-options")
    @Nullable
    public String getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    public void setCommandLineOptions(@Nullable String value) {
        this.myCommandLineOptions = StringUtil.nullize((String)value);
    }

    public void setUserDataDirectoryPath(@Nullable String value) {
        this.myUserDataDirectoryPath = PathUtil.toSystemIndependentName(StringUtil.nullize((String)value));
    }

    public void setUseCustomProfile(boolean useCustomProfile) {
        this.myUseCustomProfile = useCustomProfile;
    }

    @Override
    @NotNull
    public List<String> getAdditionalParameters() {
        if (this.myCommandLineOptions == null) {
            if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
                return Collections.singletonList(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
            }
            return Collections.emptyList();
        }
        List cliOptions = ParametersListUtil.parse((String)this.myCommandLineOptions);
        if (this.myUseCustomProfile && this.myUserDataDirectoryPath != null) {
            cliOptions.add(USER_DATA_DIR_ARG + FileUtilRt.toSystemDependentName((String)this.myUserDataDirectoryPath));
        }
        return cliOptions;
    }

    @Override
    @XMap(propertyElementName="environment-variables")
    @NotNull
    public Map<String, String> getEnvironmentVariables() {
        return this.myEnvironmentVariables;
    }

    public void setEnvironmentVariables(@NotNull Map<String, String> environmentVariables) {
        this.myEnvironmentVariables = environmentVariables;
    }

    @Override
    @NotNull
    public ChromeSettingsConfigurable createConfigurable() {
        return new ChromeSettingsConfigurable(this);
    }

    @Override
    public ChromeSettings clone() {
        ChromeSettings clone = (ChromeSettings)super.clone();
        clone.myEnvironmentVariables = new THashMap(this.myEnvironmentVariables);
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChromeSettings settings = (ChromeSettings)o;
        return this.myUseCustomProfile == settings.myUseCustomProfile && Objects.equals(this.myCommandLineOptions, settings.myCommandLineOptions) && (!this.myUseCustomProfile || Objects.equals(this.myUserDataDirectoryPath, settings.myUserDataDirectoryPath)) && this.myEnvironmentVariables.equals(settings.myEnvironmentVariables);
    }
}

