/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateElementActionBase
extends CreateInDirectoryActionBase
implements WriteActionAware {
    protected CreateElementActionBase() {
    }

    protected CreateElementActionBase(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon) {
        super(text, description, icon);
    }

    protected CreateElementActionBase(Supplier<String> dynamicText, Supplier<String> dynamicDescription, Icon icon) {
        super(dynamicText, dynamicDescription, icon);
    }

    @Deprecated
    protected PsiElement @NotNull [] invokeDialog(Project project, PsiDirectory directory) {
        return PsiElement.EMPTY_ARRAY;
    }

    protected void invokeDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull Consumer<PsiElement[]> elementsConsumer) {
        elementsConsumer.accept(this.invokeDialog(project, directory));
    }

    protected abstract PsiElement @NotNull [] create(@NotNull String var1, PsiDirectory var2) throws Exception;

    protected abstract @NlsContexts.DialogTitle String getErrorTitle();

    @Deprecated
    protected String getCommandName() {
        return "";
    }

    protected abstract @NlsContexts.Command String getActionName(PsiDirectory var1, String var2);

    @Override
    public final void actionPerformed(@NotNull AnActionEvent e) {
        IdeView view = this.getIdeView(e);
        if (view == null) {
            return;
        }
        Project project = e.getProject();
        PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null || project == null) {
            return;
        }
        this.invokeDialog(project, dir, createdElements -> {
            for (PsiElement createdElement : createdElements) {
                view.selectElement(createdElement);
            }
        });
    }

    @Nullable
    protected IdeView getIdeView(@NotNull AnActionEvent e) {
        return e.getData(LangDataKeys.IDE_VIEW);
    }

    public static String filterMessage(String message) {
        if (message == null) {
            return null;
        }
        String ioExceptionPrefix = "java.io.IOException:";
        message = StringUtil.trimStart((String)message, (String)"java.io.IOException:");
        return message;
    }

    protected class MyInputValidator
    extends ElementCreator
    implements InputValidator {
        private final PsiDirectory myDirectory;
        private PsiElement[] myCreatedElements;

        public MyInputValidator(Project project, PsiDirectory directory) {
            super(project, CreateElementActionBase.this.getErrorTitle());
            this.myCreatedElements = PsiElement.EMPTY_ARRAY;
            this.myDirectory = directory;
        }

        public PsiDirectory getDirectory() {
            return this.myDirectory;
        }

        @Override
        public boolean checkInput(String inputString) {
            return true;
        }

        @Override
        public PsiElement[] create(@NotNull String newName) throws Exception {
            return CreateElementActionBase.this.create(newName, this.myDirectory);
        }

        @Override
        public boolean startInWriteAction() {
            return CreateElementActionBase.this.startInWriteAction();
        }

        @Override
        public String getActionName(String newName) {
            return CreateElementActionBase.this.getActionName(this.myDirectory, newName);
        }

        @Override
        public boolean canClose(String inputString) {
            this.myCreatedElements = this.tryCreate(inputString);
            return this.myCreatedElements.length > 0;
        }

        public final PsiElement[] getCreatedElements() {
            return this.myCreatedElements;
        }
    }
}

