/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface ServiceEventListener {
    public static final Topic<ServiceEventListener> TOPIC = Topic.create((String)"services topic", ServiceEventListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_CHILDREN);

    public void handle(@NotNull ServiceEvent var1);

    public static enum EventType {
        RESET,
        SYNC_RESET,
        SERVICE_ADDED,
        SERVICE_REMOVED,
        SERVICE_CHANGED,
        SERVICE_STRUCTURE_CHANGED,
        SERVICE_GROUP_CHANGED,
        GROUP_CHANGED;

    }

    public static final class ServiceEvent {
        public final EventType type;
        public final Object target;
        public final Class<?> contributorClass;
        public final Object parent;

        private ServiceEvent(@NotNull EventType type, @NotNull Object target, @NotNull Class<?> contributorClass) {
            this(type, target, contributorClass, null);
        }

        private ServiceEvent(@NotNull EventType type, @NotNull Object target, @NotNull Class<?> contributorClass, @Nullable Object parent) {
            this.type = type;
            this.target = target;
            this.contributorClass = contributorClass;
            this.parent = parent;
        }

        public String toString() {
            return (Object)((Object)this.type) + ": " + this.target.toString() + "; from contributor: " + this.contributorClass + (this.parent == null ? "" : "; parent: " + this.parent);
        }

        public static ServiceEvent createEvent(@NotNull EventType type, @NotNull Object target, @NotNull Class<?> rootContributorClass) {
            return new ServiceEvent(type, target, rootContributorClass);
        }

        public static ServiceEvent createResetEvent(@NotNull Class<?> rootContributorClass) {
            return new ServiceEvent(EventType.RESET, rootContributorClass, rootContributorClass);
        }

        public static ServiceEvent createSyncResetEvent(@NotNull Class<?> rootContributorClass) {
            return new ServiceEvent(EventType.SYNC_RESET, rootContributorClass, rootContributorClass);
        }

        public static ServiceEvent createServiceAddedEvent(@NotNull Object target, @NotNull Class<?> contributorClass, @Nullable Object parent) {
            return new ServiceEvent(EventType.SERVICE_ADDED, target, contributorClass, parent);
        }
    }
}

