/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.configurationStore.XmlSerializer;
import com.intellij.diagnostic.logging.LogConsole;
import com.intellij.execution.BeforeRunTask;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.AdditionalTabComponentManager;
import com.intellij.execution.configurations.ConfigurationCreationListener;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.LogFileOptions;
import com.intellij.execution.configurations.PredefinedLogFile;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.FragmentedSettings;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunConfigurationBase<T>
extends UserDataHolderBase
implements RunConfiguration,
TargetAwareRunProfile,
ConfigurationCreationListener,
FragmentedSettings {
    private static final String SHOW_CONSOLE_ON_STD_OUT = "show_console_on_std_out";
    private static final String SHOW_CONSOLE_ON_STD_ERR = "show_console_on_std_err";
    @Nullable
    private final ConfigurationFactory myFactory;
    private final Project myProject;
    private String myName;
    private RunConfigurationOptions myOptions;
    @NotNull
    private List<BeforeRunTask<?>> myBeforeRunTasks = Collections.emptyList();

    protected RunConfigurationBase(@NotNull Project project, @Nullable ConfigurationFactory factory, @Nullable String name) {
        this.myProject = project;
        this.myFactory = factory;
        this.myName = name;
        this.myOptions = this.createOptions();
    }

    @NotNull
    private RunConfigurationOptions createOptions() {
        return (RunConfigurationOptions)ReflectionUtil.newInstance(this.getOptionsClass());
    }

    @NotNull
    protected RunConfigurationOptions getOptions() {
        return this.myOptions;
    }

    @Override
    @Transient
    @NotNull
    public List<BeforeRunTask<?>> getBeforeRunTasks() {
        return this.myBeforeRunTasks;
    }

    @Override
    public void setBeforeRunTasks(@NotNull List<BeforeRunTask<?>> value) {
        this.myBeforeRunTasks = value;
    }

    @Override
    @Nullable
    public final ConfigurationFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public final void setName(String name) {
        this.myName = name;
    }

    @Override
    @NotNull
    public final Project getProject() {
        return this.myProject;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.myFactory == null ? null : this.myFactory.getIcon();
    }

    @Override
    @Transient
    @NotNull
    public final String getName() {
        return StringUtilRt.notNullize((String)this.myName);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public void checkRunnerSettings(@NotNull ProgramRunner runner, @Nullable RunnerSettings runnerSettings, @Nullable ConfigurationPerRunnerSettings configurationPerRunnerSettings) throws RuntimeConfigurationException {
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
    }

    @Override
    public boolean canRunOn(@NotNull ExecutionTarget target) {
        return true;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public RunConfiguration clone() {
        RunConfigurationBase result = (RunConfigurationBase)super.clone();
        result.myOptions = this.createOptions();
        result.doCopyOptionsFrom(this);
        return result;
    }

    void doCopyOptionsFrom(@NotNull RunConfigurationBase<T> template) {
        this.myOptions.copyFrom(template.myOptions);
        this.myOptions.resetModificationCount();
        this.myOptions.setAllowRunningInParallel(template.isAllowRunningInParallel());
        this.myBeforeRunTasks = ContainerUtil.copyList(template.myBeforeRunTasks);
    }

    @Nullable
    public LogFileOptions getOptionsForPredefinedLogFile(PredefinedLogFile predefinedLogFile) {
        return null;
    }

    public void removeAllPredefinedLogFiles() {
        this.getOptions().getPredefinedLogFiles().clear();
    }

    public void addPredefinedLogFile(@NotNull PredefinedLogFile predefinedLogFile) {
        this.getOptions().getPredefinedLogFiles().add(predefinedLogFile);
    }

    @NotNull
    public List<PredefinedLogFile> getPredefinedLogFiles() {
        return this.getOptions().getPredefinedLogFiles();
    }

    @NotNull
    public ArrayList<LogFileOptions> getAllLogFiles() {
        ArrayList<LogFileOptions> list = new ArrayList<LogFileOptions>(this.getLogFiles());
        for (PredefinedLogFile predefinedLogFile : this.getOptions().getPredefinedLogFiles()) {
            LogFileOptions options = this.getOptionsForPredefinedLogFile(predefinedLogFile);
            if (options == null) continue;
            list.add(options);
        }
        return list;
    }

    @NotNull
    public List<LogFileOptions> getLogFiles() {
        return this.getOptions().getLogFiles();
    }

    public void addLogFile(String file, String alias, boolean checked) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked));
    }

    public void addLogFile(String file, String alias, boolean checked, boolean skipContent, boolean showAll) {
        this.getOptions().getLogFiles().add(new LogFileOptions(alias, file, checked, skipContent, showAll));
    }

    public void removeAllLogFiles() {
        this.getOptions().getLogFiles().clear();
    }

    public void createAdditionalTabComponents(AdditionalTabComponentManager manager, ProcessHandler startedProcess) {
    }

    public void customizeLogConsole(LogConsole console) {
    }

    @Nullable
    public T getState() {
        return (T)this.getOptions();
    }

    public void loadState(@NotNull T state) {
        this.myOptions = state instanceof Element ? XmlSerializer.deserialize((Element)state, this.getOptionsClass()) : (RunConfigurationOptions)state;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        boolean isAllowRunningInParallel = this.myOptions.isAllowRunningInParallel();
        this.loadState(element);
        this.myOptions.setAllowRunningInParallel(isAllowRunningInParallel);
    }

    @Override
    public void writeExternal(@NotNull Element element) {
        XmlSerializer.serializeObjectInto(this.myOptions, element);
    }

    @Override
    @NotNull
    public Set<String> getSelectedOptions() {
        return this.myOptions.getSelectedOptions();
    }

    @Override
    public void setSelectedOptions(@NotNull Set<String> fragmentIds) {
        this.myOptions.setSelectedOptions(fragmentIds);
    }

    @ApiStatus.Experimental
    public void setOptionsFromConfigurationFile(@NotNull BaseState state) {
        this.myOptions.copyFrom(state, false);
    }

    protected Class<? extends RunConfigurationOptions> getOptionsClass() {
        Class<? extends BaseState> result;
        Class<? extends BaseState> clazz = result = this.myFactory == null ? null : this.myFactory.getOptionsClass();
        if (result != null) {
            return result;
        }
        if (this instanceof PersistentStateComponent) {
            PersistentStateComponent instance = (PersistentStateComponent)((Object)this);
            return ComponentSerializationUtil.getStateClass(instance.getClass());
        }
        return this.getDefaultOptionsClass();
    }

    @NotNull
    protected Class<? extends RunConfigurationOptions> getDefaultOptionsClass() {
        return RunConfigurationOptions.class;
    }

    @Transient
    public boolean isSaveOutputToFile() {
        return this.myOptions.getFileOutput().isSaveOutput();
    }

    public void setSaveOutputToFile(boolean redirectOutput) {
        this.myOptions.getFileOutput().setSaveOutput(redirectOutput);
    }

    @Attribute(value="show_console_on_std_out")
    public boolean isShowConsoleOnStdOut() {
        return this.myOptions.isShowConsoleOnStdOut();
    }

    public void setShowConsoleOnStdOut(boolean showConsoleOnStdOut) {
        this.myOptions.setShowConsoleOnStdOut(showConsoleOnStdOut);
    }

    @Attribute(value="show_console_on_std_err")
    public boolean isShowConsoleOnStdErr() {
        return this.myOptions.isShowConsoleOnStdErr();
    }

    public void setShowConsoleOnStdErr(boolean showConsoleOnStdErr) {
        this.myOptions.setShowConsoleOnStdErr(showConsoleOnStdErr);
    }

    @Transient
    public String getOutputFilePath() {
        return this.myOptions.getFileOutput().getFileOutputPath();
    }

    public void setFileOutputPath(String fileOutputPath) {
        this.myOptions.getFileOutput().setFileOutputPath(fileOutputPath);
    }

    public boolean collectOutputFromProcessHandler() {
        return true;
    }

    @Deprecated
    public boolean excludeCompileBeforeLaunchOption() {
        return false;
    }

    public String toString() {
        return this.getType().getDisplayName() + ": " + this.getName();
    }

    @Deprecated
    protected boolean isNewSerializationUsed() {
        return false;
    }

    @Override
    public final boolean isAllowRunningInParallel() {
        return this.getOptions().isAllowRunningInParallel();
    }

    @Override
    public final void setAllowRunningInParallel(boolean value) {
        this.getOptions().setAllowRunningInParallel(value);
    }

    @Override
    public void onNewConfigurationCreated() {
    }

    @Override
    public void onConfigurationCopied() {
    }
}

