/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagnostic;

import com.intellij.diagnostic.PluginProblemReporter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginException
extends RuntimeException {
    private final PluginId myPluginId;

    public PluginException(@NotNull String message, Throwable cause, @Nullable PluginId pluginId) {
        super(message, cause);
        this.myPluginId = pluginId;
    }

    public PluginException(@NotNull Throwable e, @Nullable PluginId pluginId) {
        super(e.getMessage(), e);
        this.myPluginId = pluginId;
    }

    public PluginException(@NotNull String message, @Nullable PluginId pluginId) {
        super(message);
        this.myPluginId = pluginId;
    }

    @Nullable
    public PluginId getPluginId() {
        return this.myPluginId;
    }

    @Override
    @NotNull
    public String getMessage() {
        String message = super.getMessage();
        return this.myPluginId != null ? StringUtil.notNullize((String)message) + " [Plugin: " + this.myPluginId + "]" : message;
    }

    @NotNull
    public static PluginException createByClass(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        return PluginProblemReporter.getInstance().createPluginExceptionByClass(errorMessage, cause, pluginClass);
    }

    @NotNull
    public static PluginException createByClass(@NotNull Throwable cause, @NotNull Class<?> pluginClass) {
        return PluginProblemReporter.getInstance().createPluginExceptionByClass(StringUtil.notNullize((String)cause.getMessage()), cause, pluginClass);
    }

    public static void logPluginError(@NotNull Logger logger, @NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        logger.error((Throwable)PluginException.createByClass(errorMessage, cause, pluginClass));
    }
}

