/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlSuppressionProvider
implements InspectionSuppressor {
    public static final ExtensionPointName<XmlSuppressionProvider> EP_NAME = new ExtensionPointName("com.intellij.xml.xmlSuppressionProvider");

    public static boolean isSuppressed(@NotNull PsiElement element, @NotNull String inspectionId) {
        return EP_NAME.getExtensionList().stream().anyMatch(provider -> provider.isProviderAvailable(element.getContainingFile()) && provider.isSuppressedFor(element, inspectionId));
    }

    public abstract boolean isProviderAvailable(@NotNull PsiFile var1);

    @Override
    public abstract boolean isSuppressedFor(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForFile(@NotNull PsiElement var1, @NotNull String var2);

    public abstract void suppressForTag(@NotNull PsiElement var1, @NotNull String var2);

    @Override
    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        return XmlSuppressableInspectionTool.getSuppressFixes(toolId, this);
    }
}

