/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElementDecorator<T extends LookupElement>
extends LookupElement {
    @NotNull
    private final T myDelegate;

    protected LookupElementDecorator(@NotNull T delegate) {
        this.myDelegate = delegate;
        this.myDelegate.copyUserDataTo((UserDataHolderBase)this);
    }

    @NotNull
    public T getDelegate() {
        return this.myDelegate;
    }

    @Override
    public boolean isValid() {
        return ((LookupElement)((Object)this.myDelegate)).isValid() && super.isValid();
    }

    @Override
    @NotNull
    public String getLookupString() {
        return ((LookupElement)((Object)this.myDelegate)).getLookupString();
    }

    @Override
    public Set<String> getAllLookupStrings() {
        return ((LookupElement)((Object)this.myDelegate)).getAllLookupStrings();
    }

    @Override
    @NotNull
    public Object getObject() {
        return ((LookupElement)((Object)this.myDelegate)).getObject();
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        ((LookupElement)((Object)this.myDelegate)).handleInsert(context);
    }

    @Override
    public AutoCompletionPolicy getAutoCompletionPolicy() {
        return ((LookupElement)((Object)this.myDelegate)).getAutoCompletionPolicy();
    }

    @Override
    public String toString() {
        return ((LookupElement)((Object)this.myDelegate)).toString();
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        ((LookupElement)((Object)this.myDelegate)).renderElement(presentation);
    }

    @Override
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        final LookupElementRenderer<? extends LookupElement> renderer = ((LookupElement)((Object)this.myDelegate)).getExpensiveRenderer();
        return renderer == null ? null : new LookupElementRenderer<LookupElementDecorator<?>>(){

            @Override
            public void renderElement(LookupElementDecorator<?> element, LookupElementPresentation presentation) {
                renderer.renderElement(((LookupElementDecorator)element).myDelegate, presentation);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LookupElementDecorator that = (LookupElementDecorator)((Object)o);
        return this.myDelegate.equals(that.myDelegate);
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withInsertHandler(@NotNull T element, @NotNull InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
        return new InsertingDecorator<T>(element, insertHandler);
    }

    @NotNull
    public static <T extends LookupElement> LookupElementDecorator<T> withRenderer(@NotNull T element, @NotNull LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
        return new VisagisteDecorator<T>(element, visagiste);
    }

    @Override
    public <T> T as(ClassConditionKey<T> conditionKey) {
        T t = super.as(conditionKey);
        return t == null ? ((LookupElement)((Object)this.myDelegate)).as(conditionKey) : t;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        T t = super.as(clazz);
        return t == null ? ((LookupElement)((Object)this.myDelegate)).as(clazz) : t;
    }

    @Override
    public boolean isCaseSensitive() {
        return ((LookupElement)((Object)this.myDelegate)).isCaseSensitive();
    }

    @Override
    public boolean isWorthShowingInAutoPopup() {
        return ((LookupElement)((Object)this.myDelegate)).isWorthShowingInAutoPopup();
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        return ((LookupElement)((Object)this.myDelegate)).getPsiElement();
    }

    private static class VisagisteDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final LookupElementRenderer<? super LookupElementDecorator<T>> myVisagiste;

        VisagisteDecorator(T element, LookupElementRenderer<? super LookupElementDecorator<T>> visagiste) {
            super(element);
            this.myVisagiste = visagiste;
        }

        @Override
        public void renderElement(LookupElementPresentation presentation) {
            this.myVisagiste.renderElement(this, presentation);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            VisagisteDecorator that = (VisagisteDecorator)((Object)o);
            return this.myVisagiste.getClass().equals(that.myVisagiste.getClass());
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myVisagiste.getClass().hashCode();
            return result;
        }
    }

    private static class InsertingDecorator<T extends LookupElement>
    extends LookupElementDecorator<T> {
        private final InsertHandler<? super LookupElementDecorator<T>> myInsertHandler;

        InsertingDecorator(T element, InsertHandler<? super LookupElementDecorator<T>> insertHandler) {
            super(element);
            this.myInsertHandler = insertHandler;
        }

        @Override
        public void handleInsert(@NotNull InsertionContext context) {
            this.myInsertHandler.handleInsert(context, this);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InsertingDecorator that = (InsertingDecorator)((Object)o);
            return this.myInsertHandler.equals(that.myInsertHandler);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.myInsertHandler.hashCode();
            return result;
        }
    }
}

