/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PriorityIntentionActionWrapper
implements IntentionAction,
PriorityAction {
    private final IntentionAction myAction;
    private final PriorityAction.Priority myPriority;

    private PriorityIntentionActionWrapper(@NotNull IntentionAction action, @NotNull PriorityAction.Priority priority) {
        this.myAction = action;
        this.myPriority = priority;
    }

    @Override
    @NotNull
    public String getText() {
        return this.myAction.getText();
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return this.myAction.getFamilyName();
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        return this.myAction.isAvailable(project, editor, file);
    }

    @Override
    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        this.myAction.invoke(project, editor, file);
    }

    @Override
    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file) {
        return this.myAction.getElementToMakeWritable(file);
    }

    @Override
    public boolean startInWriteAction() {
        return this.myAction.startInWriteAction();
    }

    @Override
    @NotNull
    public PriorityAction.Priority getPriority() {
        return this.myPriority;
    }

    @Override
    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        IntentionAction delegate = (IntentionAction)ObjectUtils.tryCast((Object)this.myAction.getFileModifierForPreview(target), IntentionAction.class);
        return delegate == null ? null : (delegate == this.myAction ? this : new PriorityIntentionActionWrapper(delegate, this.myPriority));
    }

    @NotNull
    public static IntentionAction highPriority(@NotNull IntentionAction action) {
        return new PriorityIntentionActionWrapper(action, PriorityAction.Priority.HIGH);
    }

    @NotNull
    public static IntentionAction normalPriority(@NotNull IntentionAction action) {
        return new PriorityIntentionActionWrapper(action, PriorityAction.Priority.NORMAL);
    }

    @NotNull
    public static IntentionAction lowPriority(@NotNull IntentionAction action) {
        return new PriorityIntentionActionWrapper(action, PriorityAction.Priority.LOW);
    }
}

