/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.application.WriteActionAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ReflectionUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface FileModifier
extends WriteActionAware {
    @Nullable
    default public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return this.startInWriteAction() ? currentFile : null;
    }

    @Nullable
    default public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (!this.startInWriteAction()) {
            return null;
        }
        for (Field field : ReflectionUtil.collectFields(this.getClass())) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            Class<?> type = field.getType();
            if (field.getAnnotation(SafeFieldForPreview.class) != null) continue;
            while (type.isArray()) {
                type = type.getComponentType();
            }
            if (type.isPrimitive() || type.isEnum() || type.equals(String.class) || type.equals(Class.class) || type.equals(Integer.class) || type.equals(Boolean.class) || field.isSynthetic() && field.getName().equals("this$0") && LocalInspectionTool.class.isAssignableFrom(type)) continue;
            return null;
        }
        return this;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface SafeFieldForPreview {
    }
}

