/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.IPopupChooserBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MergeableLineMarkerInfo<T extends PsiElement>
extends LineMarkerInfo<T> {
    private static final Logger LOG = Logger.getInstance(MergeableLineMarkerInfo.class);

    @Deprecated
    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, int updatePass, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        super(element, textRange, icon, tooltipProvider, navHandler, alignment);
    }

    public MergeableLineMarkerInfo(@NotNull T element, @NotNull TextRange textRange, Icon icon, @Nullable Function<? super T, String> tooltipProvider, @Nullable GutterIconNavigationHandler<T> navHandler, @NotNull GutterIconRenderer.Alignment alignment) {
        super(element, textRange, icon, tooltipProvider, navHandler, alignment);
    }

    public abstract boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> var1);

    public abstract Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> var1);

    @NotNull
    public Function<? super PsiElement, String> getCommonTooltip(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        return element -> {
            HashSet tooltips = new HashSet(ContainerUtil.mapNotNull((Collection)infos, info -> info.getLineMarkerTooltip()));
            StringBuilder tooltip = new StringBuilder();
            for (String info2 : tooltips) {
                if (tooltip.length() > 0) {
                    tooltip.append("<hr size=1 noshade>");
                }
                tooltip.append(UIUtil.getHtmlBody((String)info2));
            }
            return XmlStringUtil.wrapInHtml((CharSequence)tooltip);
        };
    }

    public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        return GutterIconRenderer.Alignment.LEFT;
    }

    @NotNull
    public String getElementPresentation(@NotNull PsiElement element) {
        return element.getText();
    }

    private int getCommonUpdatePass(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
        return this.updatePass;
    }

    @NotNull
    public static List<LineMarkerInfo<?>> merge(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
        SmartList result = new SmartList();
        for (int i = 0; i < markers.size(); ++i) {
            MergeableLineMarkerInfo<?> marker = markers.get(i);
            SmartList toMerge = new SmartList();
            for (int k = markers.size() - 1; k > i; --k) {
                MergeableLineMarkerInfo<?> current = markers.get(k);
                boolean canMergeWith = marker.canMergeWith(current);
                if (ApplicationManager.getApplication().isUnitTestMode() && !canMergeWith && current.canMergeWith(marker)) {
                    LOG.error(current.getClass() + "[" + current.getLineMarkerTooltip() + "] can merge " + marker.getClass() + "[" + marker.getLineMarkerTooltip() + "], but not contrariwise");
                }
                if (!canMergeWith) continue;
                toMerge.add(0, current);
                markers.remove(k);
            }
            if (toMerge.isEmpty()) {
                result.add(marker);
                continue;
            }
            toMerge.add(0, marker);
            result.add(new MyLineMarkerInfo((List)toMerge));
        }
        return result;
    }

    static class MergedGutterIconNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final List<LineMarkerInfo<?>> myInfos;

        MergedGutterIconNavigationHandler(List<? extends MergeableLineMarkerInfo<?>> markers) {
            ArrayList infos = new ArrayList(markers);
            infos.sort(Comparator.comparingInt(o -> o.startOffset));
            this.myInfos = Collections.unmodifiableList(infos);
        }

        @NotNull
        List<LineMarkerInfo<?>> getMergedLineMarkersInfos() {
            return this.myInfos;
        }

        @Override
        public void navigate(MouseEvent e, PsiElement elt) {
            IPopupChooserBuilder<LineMarkerInfo<?>> builder = JBPopupFactory.getInstance().createPopupChooserBuilder(this.myInfos);
            builder.setRenderer(new SelectionAwareListCellRenderer(dom -> {
                Object element;
                Icon icon = null;
                GutterIconRenderer renderer = dom.createGutterRenderer();
                if (renderer != null) {
                    icon = renderer.getIcon();
                }
                String elementPresentation = (element = dom.getElement()) == null ? IdeBundle.message("node.structureview.invalid", new Object[0]) : (dom instanceof MergeableLineMarkerInfo ? ((MergeableLineMarkerInfo)dom).getElementPresentation((PsiElement)element) : element.getText());
                String text = StringUtil.first((String)elementPresentation, (int)100, (boolean)true).replace('\n', ' ');
                JBLabel label = new JBLabel(text, icon, 2);
                label.setBorder(JBUI.Borders.empty((int)2));
                return label;
            }));
            builder.setItemChosenCallback(value -> {
                GutterIconNavigationHandler handler = value.getNavigationHandler();
                if (handler != null) {
                    handler.navigate(e, value.getElement());
                }
            }).createPopup().show(new RelativePoint(e));
        }
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            this(markers, markers.get(0));
        }

        private MyLineMarkerInfo(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers, @NotNull MergeableLineMarkerInfo<?> template) {
            super(template.getElement(), MyLineMarkerInfo.getCommonTextRange(markers), template.getCommonIcon(markers), template.getCommonTooltip(markers), MyLineMarkerInfo.getCommonNavigationHandler(markers), template.getCommonIconAlignment(markers));
        }

        @NotNull
        private static TextRange getCommonTextRange(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            int startOffset = Integer.MAX_VALUE;
            int endOffset = Integer.MIN_VALUE;
            for (MergeableLineMarkerInfo<?> marker : markers) {
                startOffset = Math.min(startOffset, marker.startOffset);
                endOffset = Math.max(endOffset, marker.endOffset);
            }
            return TextRange.create((int)startOffset, (int)endOffset);
        }

        @NotNull
        private static GutterIconNavigationHandler<PsiElement> getCommonNavigationHandler(@NotNull List<? extends MergeableLineMarkerInfo<?>> markers) {
            return new MergedGutterIconNavigationHandler(markers);
        }
    }
}

